package com.liquidnet.service.goblin.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.codec.vo.EncryptedReq;
import com.liquidnet.service.goblin.dto.manage.GoblinOrderParam;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinPayInnerResultVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfMarketingVo;
import com.liquidnet.service.goblin.service.IGoblinAppOrderService;
import com.liquidnet.service.goblin.service.IGoblinAppZhengzaiService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@Api(tags = "订单相关")
@RestController
@RequestMapping("/order")
public class GoblinAppOrderController {

    @Autowired
    IGoblinAppOrderService goblinAppOrderService;

    @PostMapping("pre")
    @ApiOperation("下单")
    public ResponseDto<GoblinPayInnerResultVo> getZhengzaiMarketList(@RequestBody EncryptedReq<GoblinOrderParam> param) {
        GoblinOrderParam payOrderParam = param.getData();
        return goblinAppOrderService.checkOrder(payOrderParam);
    }

    @PostMapping("fc7bce6d6c2213b866f76493f92224b7")
    @ApiOperation("fc7bce6d6c2213b866f76493f92224b7")
    public ResponseDto<GoblinPayInnerResultVo> getZhengzaiMarketList(@RequestBody GoblinOrderParam param) {
        return goblinAppOrderService.checkOrder(param);
    }
}
