package com.liquidnet.service.platform.controller.sweet;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.feign.stone.api.FeignStoneIntegralClient;
import com.liquidnet.service.platform.utils.DataUtils;
import com.liquidnet.service.sweet.entity.SweetWechatUsers;
import com.liquidnet.service.sweet.mapper.SweetWechatUsersMapper;
import com.liquidnet.service.sweet.vo.SweetAppletUsersVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 关注任务加积分脚本
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-12-28
 */
@Api(tags = "关注任务加积分脚本")
@Slf4j
@RestController
@RequestMapping("followDoTask")
public class TaskController {

    @Autowired
    private SweetWechatUsersMapper usersMapper;

    @Autowired
    private FeignStoneIntegralClient feignStoneIntegralClient;

    @Autowired
    private DataUtils dataUtils;

    @GetMapping("doTask")
    @ApiOperation("退款回调")
    public ResponseDto doTask() {
        int size = 1000;

        LocalDateTime localDateTime = LocalDateTime.now();
        LocalDateTime newTime = localDateTime.minusHours(10);
//        String timeStr = "2021-12-28 00:00:00";
//        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
//        LocalDateTime dateTime = LocalDateTime.parse(timeStr, df);
        // 获取总记录数
        Integer count = usersMapper.selectCount(
                Wrappers.lambdaQuery(SweetWechatUsers.class)
                        .gt(SweetWechatUsers::getCreatedAt, newTime)
                        .eq(SweetWechatUsers::getType, 2)
        );
        // 总page
        int countPage = (int) Math.ceil(count / size);
        countPage = countPage + 1;
        for (int page = 0; page < countPage; page++) {
            List<SweetWechatUsers> sweetWechatUsers = usersMapper.selectList(
                    Wrappers.lambdaQuery(SweetWechatUsers.class).last("limit " + (page * size) + "," + ((page + 1) * size))
            );
            for (SweetWechatUsers info : sweetWechatUsers) {
                try {
                    SweetAppletUsersVo sweetAppletUsers = dataUtils.getSweetAppletUsersOfUnionId(info.getUnionId());
                    if (sweetAppletUsers != null) {
                        if (sweetAppletUsers.getUserId() != null && !sweetAppletUsers.getUserId().isEmpty()) {
                            log.info("followDoTask userId:{}", sweetAppletUsers.getUserId());
                            feignStoneIntegralClient.doTask(4, sweetAppletUsers.getUserId());
                        }
                    }
                } catch (Exception e) {

                }
            }
        }
        return ResponseDto.success();
    }

}
