package com.liquidnet.service.feign.bank.api.currencycloud;

import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcAccountCreateDto;
import com.liquidnet.service.bank.currencycloud.entity.BankCcBalance;
import com.liquidnet.service.feign.bank.api.constant.FeignBankConstant;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Service
@FeignClient(name = FeignBankConstant.LIQUIDNET_SERVICE_BANK,
        path = FeignBankConstant.CONTEXT_PATH,
        fallback = FallbackFactory.Default.class,
        contextId = FeignBankConstant.CONTEXT_BANK_CC_BALANCE)
public interface FeignBankCcBalanceClient {

    @RequestMapping(value = "/bank-cc-balance/retrieve", method = RequestMethod.GET)
    ResponseDto<BankCcBalance> retrieveBalance(@RequestParam String currency, @RequestParam(required = false) String contactId);

}
