package com.liquidnet.service.api.sequence.feign;

import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@Component
@FeignClient(name = "liquidnet-service-sequence", path = "service-sequence", fallback = FallbackFactory.Default.class)
public interface FeignSequenceClient {

    @GetMapping(value = "nextIncrId/{sn}")
    Long nextIncrId(@PathVariable("sn") String sn);

    @GetMapping(value = "nextId")
    Long nextId();

    @GetMapping(value = "nextId/{number}")
    Long[] nextId(@PathVariable("number") int number);
}
