package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.commons.lang.util.BsonUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.AdamThirdPartParam;
import com.liquidnet.service.adam.dto.vo.AdamRealInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamThirdPartInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.adam.entity.AdamEnters;
import com.liquidnet.service.adam.entity.AdamRealName;
import com.liquidnet.service.adam.entity.AdamUser;
import com.liquidnet.service.adam.mapper.AdamUserMapper;
import com.liquidnet.service.adam.service.IAdamEntersService;
import com.liquidnet.service.adam.service.IAdamRealNameService;
import com.liquidnet.service.adam.service.IAdamThirdPartyService;
import com.liquidnet.service.adam.service.IAdamUserService;
import com.liquidnet.service.base.SqlMapping;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.result.UpdateResult;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/**
 * <p>
 * 用户 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-10
 */
@Service
public class AdamUserServiceImpl extends ServiceImpl<AdamUserMapper, AdamUser> implements IAdamUserService {
    @Autowired
    MongoConverter mongoConverter;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    IAdamEntersService adamEntersService;
    @Autowired
    IAdamThirdPartyService adamThirdPartyService;
    @Autowired
    IAdamRealNameService adamRealNameService;

    @Override
    public AdamUserInfoVo queryByUid(String uid) {
        AdamUserInfoVo userInfoVo = (AdamUserInfoVo) redisUtil.hget(AdamRedisConst.INFO_USER, uid);
        if (null == userInfoVo) {
            userInfoVo = mongoTemplate.findOne(Query.query(Criteria.where("uid").is(uid).and("state").is(1)),
                    AdamUserInfoVo.class, AdamUserInfoVo.class.getSimpleName());

            if (null != userInfoVo) redisUtil.hset(AdamRedisConst.INFO_USER, uid, userInfoVo);
        }
        return userInfoVo;
    }

    @Override
    public String queryUidByRedis(String mobile) {
        return (String) redisUtil.hget(AdamRedisConst.INFO_IDENTITY_MOBILE, mobile);

//        AdamUserInfoVo userInfoVo;
//        if (null == (userInfoVo = (AdamUserInfoVo) redisUtil.hget(AdamRedisConst.INFO_MOBILES, mobile))) {
//            userInfoVo = mongoTemplate.findOne(Query.query(Criteria.where("mobile").is(mobile).and("state").is(1)),
//                    AdamUserInfoVo.class, AdamUserInfoVo.class.getSimpleName());
//
//            redisUtil.hset(AdamRedisConst.INFO_MOBILES, mobile, userInfoVo);
//        }
//        return userInfoVo;
    }

    @Override
    public String queryUidByRedis(String openId, String platform) {
        return (String) redisUtil.hget(AdamRedisConst.INFO_IDENTITY_THIRD_PARTY, platform.concat(openId));
    }

    @Override
    public AdamUserInfoVo register(String mobile) {
        AdamUserInfoVo userInfoVo = AdamUserInfoVo.getNew();
        userInfoVo.setMobile(mobile);
        userInfoVo.setUid(IDGenerator.nextSnowId() + "");
        userInfoVo.setIsComplete(0);
        userInfoVo.setState(1);
        userInfoVo.setCreateAt(DateUtil.format(LocalDateTime.now(), DateUtil.Formatter.yyyyMMddHHmmss));

//        boolean hset = redisUtil.hset(AdamRedisConst.INFO_MOBILES, userInfoVo.getMobile(), userInfoVo);

        Collection<AdamUserInfoVo> vos = mongoTemplate.insert(Collections.singletonList(userInfoVo), AdamUserInfoVo.class.getSimpleName());
        redisUtil.hset(AdamRedisConst.INFO_IDENTITY_MOBILE, mobile, userInfoVo.getUid());

        return userInfoVo;
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public AdamUserInfoVo register(AdamThirdPartParam param) {
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.format(now, DateUtil.Formatter.yyyyMMddHHmmss);

        String uid = this.queryUidByRedis(param.getMobile());
        AdamUserInfoVo userInfoVo;
        if (StringUtils.isEmpty(uid)) {// 手机号未注册
            userInfoVo = AdamUserInfoVo.getNew();

            userInfoVo.setMobile(param.getMobile());
            userInfoVo.setUid(IDGenerator.nextSnowId() + "");
            userInfoVo.setCreateAt(nowStr);

            Collection<AdamUserInfoVo> userInfoVos = mongoTemplate.insert(Collections.singletonList(userInfoVo), AdamUserInfoVo.class);
        } else {
            userInfoVo = this.queryByUid(uid);
        }

        AdamThirdPartInfoVo thirdPartInfoVo = AdamThirdPartInfoVo.getNew();
        BeanUtils.copyProperties(param, thirdPartInfoVo);
        thirdPartInfoVo.setCreatedAt(nowStr);
        thirdPartInfoVo.setUid(userInfoVo.getUid());
        thirdPartInfoVo.setState(1);// 1-绑定

//        boolean userInfoSetRst = redisUtil.hset(AdamRedisConst.INFO_MOBILES, thirdPartParam.getMobile(), userInfoVo);
//        boolean thirdPartSetRst = redisUtil.hset(AdamRedisConst.INFO_THIRD_PARTY.concat(thirdPartInfoVo.getPlatform()), thirdPartInfoVo.getOpenId(), thirdPartInfoVo);

        Collection<AdamThirdPartInfoVo> thirdPartInfoVos = mongoTemplate.insert(Collections.singletonList(thirdPartInfoVo), AdamThirdPartInfoVo.class);
        // TODO: 2021/5/14 Execute sql to mq

        redisUtil.hset(AdamRedisConst.INFO_IDENTITY_THIRD_PARTY, param.getPlatform().concat(param.getOpenId()), userInfoVo.getUid());

//        List<Object> paramList = Arrays.asList();
//        rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
//                SqlMapping.get("adam_user.add", paramList.toArray()));
        return userInfoVo;
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void bindTpa(String uid, AdamThirdPartParam param) {
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.format(now, DateUtil.Formatter.yyyyMMddHHmmss);

        AdamThirdPartInfoVo thirdPartInfoVo = AdamThirdPartInfoVo.getNew();
        BeanUtils.copyProperties(param, thirdPartInfoVo);
        thirdPartInfoVo.setCreatedAt(nowStr);
        thirdPartInfoVo.setUid(uid);
        thirdPartInfoVo.setState(1);// 1-绑定

        mongoTemplate.insert(Collections.singletonList(thirdPartInfoVo), AdamThirdPartInfoVo.class);
        // TODO: 2021/5/14 Execute sql to mq

        redisUtil.hset(AdamRedisConst.INFO_IDENTITY_THIRD_PARTY, param.getPlatform().concat(param.getOpenId()), uid);

        redisUtil.hdel(AdamRedisConst.INFO_THIRD_PARTY, uid);
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public List<AdamThirdPartInfoVo> bindTpaForce(String bindUid, String unBindUid, AdamThirdPartParam param) {
        this.unBindTpaProcess(unBindUid, param.getPlatform());

        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.format(now, DateUtil.Formatter.yyyyMMddHHmmss);

        AdamThirdPartInfoVo thirdPartInfoVo = AdamThirdPartInfoVo.getNew();
        BeanUtils.copyProperties(param, thirdPartInfoVo);
        thirdPartInfoVo.setCreatedAt(nowStr);
        thirdPartInfoVo.setUid(bindUid);
        thirdPartInfoVo.setState(1);// 1-绑定

        mongoTemplate.insert(Collections.singletonList(thirdPartInfoVo), AdamThirdPartInfoVo.class);
        // TODO: 2021/5/14 Execute sql to mq

        redisUtil.hset(AdamRedisConst.INFO_IDENTITY_THIRD_PARTY, param.getPlatform().concat(param.getOpenId()), bindUid);

        List<AdamThirdPartInfoVo> thirdPartInfoVos = mongoTemplate.find(Query.query(Criteria.where("uid").is(bindUid).and("state").is(1)),
                AdamThirdPartInfoVo.class, AdamThirdPartInfoVo.class.getSimpleName());
        redisUtil.hset(AdamRedisConst.INFO_THIRD_PARTY, bindUid, thirdPartInfoVos);

        return thirdPartInfoVos;
    }

    private void unBindTpaProcess(String uid, String platform) {
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.format(now, DateUtil.Formatter.yyyyMMddHHmmss);

        AdamThirdPartInfoVo unBindThirdPartInfoVo = AdamThirdPartInfoVo.getNew();
        unBindThirdPartInfoVo.setUpdatedAt(nowStr);
        unBindThirdPartInfoVo.setState(2);// 2-解绑
        BasicDBObject object = new BasicDBObject("$set", mongoConverter.convertToMongoType(unBindThirdPartInfoVo));
        mongoTemplate.getCollection(AdamThirdPartInfoVo.class.getSimpleName()).findOneAndUpdate(
                Query.query(Criteria.where("uid").is(uid).and("platform").is(platform).and("state").is(1)).getQueryObject(),
                object
        );
        // TODO: 2021/5/14 Execute sql to mq
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public List<AdamThirdPartInfoVo> unBindTpa(String uid, String platform) {
        this.unBindTpaProcess(uid, platform);

        List<AdamThirdPartInfoVo> unBindUserThirdPartInfoVos = mongoTemplate.find(Query.query(Criteria.where("uid").is(uid).and("state").is(1)),
                AdamThirdPartInfoVo.class, AdamThirdPartInfoVo.class.getSimpleName());
        // TODO: 2021/5/14 Execute sql to mq
        
        redisUtil.hset(AdamRedisConst.INFO_THIRD_PARTY, uid, unBindUserThirdPartInfoVos);
        return unBindUserThirdPartInfoVos;
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void close(String uid) {
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.format(now, DateUtil.Formatter.yyyyMMddHHmmss);

        AdamUserInfoVo closeUserInfoVo = AdamUserInfoVo.getNew();
        closeUserInfoVo.setState(2);
        closeUserInfoVo.setUpdatedAt(nowStr);
        closeUserInfoVo.setClosedAt(closeUserInfoVo.getUpdatedAt());

        BasicDBObject object = new BasicDBObject("$set", mongoConverter.convertToMongoType(closeUserInfoVo));
        Document doc = mongoTemplate.getCollection(AdamUserInfoVo.class.getSimpleName()).findOneAndUpdate(
                Query.query(Criteria.where("uid").is(closeUserInfoVo.getUid())).getQueryObject(),
                object, new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
        );
        List<Object> paramList = Arrays.asList(closeUserInfoVo.getState(), now, now, uid);
//        rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
//                SqlMapping.get("adam_user.close", paramList.toArray()));
        // TODO: 2021/5/14 Execute sql to mq

        redisUtil.hdel(AdamRedisConst.INFO_USER, uid);

        redisUtil.hdel(AdamRedisConst.INFO_IDENTITY_MOBILE, closeUserInfoVo.getMobile(), uid);

        /* ---------------------- 收货地址信息 */

        List<AdamThirdPartInfoVo> thirdPartInfoVoList = adamThirdPartyService.queryByUid(uid);

        redisUtil.hdel(AdamRedisConst.INFO_THIRD_PARTY, uid);

        for (AdamThirdPartInfoVo o : thirdPartInfoVoList) {
            this.unBindTpaProcess(uid, o.getPlatform());
        }
        // TODO: 2021/5/14 Execute sql to mq

        /* ---------------------- 入场人信息 */
        List<AdamEnters> entersList = adamEntersService.queryByUid(uid);

        redisUtil.del(AdamRedisConst.INFO_ENTERS.concat(uid));

        AdamEnters closeEnters = new AdamEnters();
        closeEnters.setUpdatedAt(LocalDateTime.now());
        closeEnters.setDeletedAt(closeEnters.getUpdatedAt());
        closeEnters.setState(2);

        object = new BasicDBObject("$set", mongoConverter.convertToMongoType(closeEnters));
        UpdateResult updateResult = mongoTemplate.getCollection(AdamEnters.class.getSimpleName())
                .updateOne(Query.query(Criteria.where("uid").is(uid)).getQueryObject(), object);
        // TODO: 2021/5/14 Execute sql to mq
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public AdamRealInfoVo identity(String uid, String name, String idCard) {
        // TODO: 2021/5/18 调用第三方认证服务

        AdamRealName realName = new AdamRealName();
        realName.setRealNameId(IDGenerator.nextSnowId() + "");
        realName.setUid(uid);
        realName.setType("1");
        realName.setName(name);
        realName.setIdCard(idCard);
        realName.setState(1);
        realName.setCreatedAt(LocalDateTime.now());
        adamRealNameService.add(realName);

        AdamRealInfoVo realInfoVo = AdamRealInfoVo.getNew();
        realInfoVo.setName(StringUtils.rightPad(StringUtils.left(name, 1), name.length(), "*"));
        realInfoVo.setIdCard(StringUtils.rightPad(StringUtils.left(idCard, 3), idCard.length(), "*").concat(StringUtils.right(idCard, 2)));
        realInfoVo.setState(1);

        redisUtil.hset(AdamRedisConst.INFO_REAL_NAME, uid, realInfoVo);

        // TODO: 2021/5/18 修改UserInfoVo，同步redis


        return realInfoVo;
    }
}
