package com.liquidnet.service.goblin.controller;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.service.impl.GoblinFrontServiceImpl;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.text.ParseException;

/**
 * @author zhangfuxin
 * @Description:前端接口
 * @date 2021/12/27 下午6:25
 */
@Api(tags = "前端接口管理")
@RestController
@RequestMapping("/front")
public class GoblinFrontController {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    private GoblinFrontServiceImpl goblinFrontService;

    @GetMapping("getBanner")
    @ApiOperation("获取banner")
    public ResponseDto getBanner() {
        return ResponseDto.success( goblinFrontService.getListBanner());
    }
    @GetMapping("getHotWord")
    @ApiOperation("获得热词")
    public ResponseDto getHotWord() {
        return ResponseDto.success( goblinFrontService.getHotWord() );
    }
    @GetMapping("getNavigation")
    @ApiOperation("获得金刚栏")
    public ResponseDto getNavigation() {
        return ResponseDto.success( goblinFrontService.getNavigation() );
    }

    @GetMapping("getSeckilll")
    @ApiOperation("获得秒杀首页要用的")
    public ResponseDto getSeckilll() throws ParseException {
        return ResponseDto.success( goblinFrontService.getSeckilll());
    }





}
