package com.liquidnet.service.kylin.dao;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class OrderRefundDao implements Serializable {

    private String orderRefundsId;

    private String orderTicketsId;

    private String orderRefundCode;

    private String orderRefundBatchesId;

    private String refundCode;

    private String refundAt;

    private String refundId;

    private String refundError;

    private BigDecimal price;
    private BigDecimal priceExpress;

    private Integer status;

    private String statusName;

    private Integer type;

    private String applicantId;

    private String applicantName;

    private LocalDateTime applicantAt;

    private String reason;

    private String auditorId;

    private String auditorName;

    private LocalDateTime auditorAt;

    private String reject;

    private String executorId;

    private String executorName;

    private LocalDateTime executorAt;

    private String refuse;

    private String ticketAuditId;

    private String ticketAuditName;

    private LocalDateTime ticketAuditAt;

    private String ticketAuditRemark;

    private String refundType;

    private String createdAt;

    private String updatedAt;

    private String orderCode;

    private String performanceTitle;

    public void setStatusName(Integer status){
        this.status=status;
        switch (status){
            case 0:
                this.statusName="请求退款";
                break;
            case 1:
                this.statusName="一审通过";
                break;
            case 2:
                this.statusName="取消退款";
                break;
            case 3:
                this.statusName="正在退款";
                break;
            case 4:
                this.statusName="完成退款";
                break;
            case 5:
                this.statusName="一审驳回退款";
                break;
            case 6:
                this.statusName="退款失败";
                break;
            case 7:
                this.statusName="二审通过等待退款";
                break;
            case 8:
                this.statusName="二审驳回退款";
                break;
            case 9:
                this.statusName="已确认收货";
                break;
            default:
                this.statusName="其他";
                break;
        }
    }
}
