package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinStoreErpConfigVo", description = "店铺ERP配置")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinStoreErpConfigVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -12487121131698044L;
    private String storeId;
    private String sid;
    private String appKey;
    private String appSecret;
    private String shopNo;

    private static final GoblinStoreErpConfigVo obj = new GoblinStoreErpConfigVo();

    public static GoblinStoreErpConfigVo getNew() {
        try {
            return (GoblinStoreErpConfigVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreErpConfigVo();
        }
    }
}
