package com.liquidnet.common.third.easemob.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: EasemobConfig
 * @Package com.liquidnet.common.third.easemob.config
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/7 10:42
 */
@Configuration
public class EasemobConfig {
    @Value("${liquidnet.easemob.api-url}")
    private String REQUEST_HOST;
    @Value("${liquidnet.easemob.org-name}")
    private String ORG_NAME;
    @Value("${liquidnet.easemob.app-name}")
    private String APP_NAME;
    @Value("${liquidnet.easemob.client-id}")
    private String CLIENT_ID;
    @Value("${liquidnet.easemob.client-secret}")
    private String CLIENT_SECRET;

//    private String APPKEY = easemobConfig.ORG_NAME+"#"+this.APP_NAME;

    public String getPreUrl() {
        return REQUEST_HOST + "/" + ORG_NAME + "/" + APP_NAME;
    }

    public String getClientId() {
        return this.CLIENT_ID;
    }

    public String getClientSecret() {
        return this.CLIENT_SECRET;
    }
}
