package com.liquidnet.service.candy.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

@ApiModel(value = "CandyCouponPreVo", description = "会员权益券统计")
public class CandyCouponPreVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 3741851732227825227L;
    @ApiModelProperty(value = "权益ID", example = "权益ID")
    private String mcouponId;
    @ApiModelProperty(value = "当前可用券数量", example = "6")
    private Long availableCt;

    public String getMcouponId() {
        return mcouponId;
    }

    public CandyCouponPreVo setMcouponId(String mcouponId) {
        this.mcouponId = mcouponId;
        return this;
    }

    public Long getAvailableCt() {
        return availableCt;
    }

    public CandyCouponPreVo setAvailableCt(Long availableCt) {
        this.availableCt = availableCt;
        return this;
    }

    private static final CandyCouponPreVo obj = new CandyCouponPreVo();

    public static CandyCouponPreVo getNew() {
        try {
            return (CandyCouponPreVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new CandyCouponPreVo();
        }
    }
}
