package com.liquidnet.service.goblin.controller;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateAddParam;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateValueParam;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinGoodsAnticipateValueVo;
import com.liquidnet.service.goblin.service.IGoblinGoodsAnticipateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpRequest;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.math.BigInteger;

/**
 * <p>
 * 预约表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
@Slf4j
@RestController
@Api(tags = "预约相关")
@RequestMapping("/goblin/anticipate")
public class GoblinGoodsAnticipateController {

    @Autowired
    IGoblinGoodsAnticipateService goblinGoodsAnticipateService;

    @ApiOperation("用户预约（state预约标识：0为预约，1为取消预约）")
    @PostMapping("/userAbout")
    public ResponseDto<Object> userAbout(HttpServletRequest request,
                                         @RequestParam(name = "skuId", required = true) String skuId,
                                         @RequestParam(name = "uid", required = true) String uid,
                                         @RequestParam(name = "phone", required = true) String phone) {

        String url = "url";
        return goblinGoodsAnticipateService.userAbout(skuId, uid, phone, 0,url);
    }

}
