package com.liquidnet.service.goblin.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.dto.GoblinQueueBizArtworkGenDto;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.service.IGoblinUserDigitalArtworkService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import com.liquidnet.service.goblin.util.QueueUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@Service
public class GoblinUserDigitalArtworkServiceImpl implements IGoblinUserDigitalArtworkService {
    @Autowired
    private QueueUtils queueUtils;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    private GoblinMongoUtils goblinMongoUtils;


    @Autowired
    Environment env;
//    @Value("${liquidnet.service.galaxy.url}")// TODO: 2022/3/31 ==zhanggb
//    private String sevGalaxyUrl;

    @Override
    public GoblinUserDigitalArtworkPageVo page(String uid, Integer pageNum, Integer pageSize) {
        GoblinUserDigitalArtworkPageVo pageVo = GoblinUserDigitalArtworkPageVo.getNew();
        long artworkNum = goblinRedisUtils.countUserDigitalArtwork(uid);
        if (artworkNum > 0) {
            if (artworkNum > 30 && pageNum * pageSize > 30) {// 查询Mongo
                PagedResult<GoblinUserDigitalArtworkListVo> listVoPagedResult = goblinMongoUtils.getUserDigitalArtworkListVos(uid, pageNum, pageSize);
                listVoPagedResult.setTotal(artworkNum, pageSize);
                pageVo.setArtworkNum((int) artworkNum).setPagedResult(listVoPagedResult);
            } else {
                PagedResult<GoblinUserDigitalArtworkListVo> listVoPagedResult = ObjectUtil.getGoblinUserDigitalArtworkListVoPagedResult();
                List<GoblinUserDigitalArtworkListVo> list = ObjectUtil.getGoblinUserDigitalArtworkListVoArrayList();

                List<String> userDigitalArtworkIds = goblinRedisUtils.getUserDigitalArtworkIds(uid);
                if (!CollectionUtils.isEmpty(userDigitalArtworkIds)) {
                    int cacheSize = userDigitalArtworkIds.size(), cacheNum = cacheSize / pageSize + 1;// 分几页
                    int fromIndex = Math.min(Math.min(cacheNum, pageNum - 1) * pageSize, cacheSize - 1);
                    List<String> subList = userDigitalArtworkIds.subList(fromIndex, Math.min(fromIndex + pageSize, cacheSize));

                    LocalDateTime now = LocalDateTime.now(), toCheckTime = now.minusSeconds(15);
                    int subSize = subList.size();
                    for (int i = 0; i < subSize; i++) {
                        GoblinUserDigitalArtworkVo userDigitalArtworkVo = goblinRedisUtils.getUserDigitalArtworkVo(subList.get(i));
                        if (null != userDigitalArtworkVo) {
                            GoblinGoodsSkuInfoVo goodsSkuInfoVo = goblinRedisUtils.getGoodsSkuInfoVo(userDigitalArtworkVo.getSkuId());

                            GoblinUserDigitalArtworkListVo listVo = GoblinUserDigitalArtworkListVo.getNew().copy(userDigitalArtworkVo);
                            listVo.setName(goodsSkuInfoVo.getName());
                            listVo.setSubtitle(goodsSkuInfoVo.getSubtitle());
                            listVo.setCoverPic(goodsSkuInfoVo.getSkuPic());
                            listVo.setEdition(goodsSkuInfoVo.getSkuStock());
                            listVo.setUnbox(goodsSkuInfoVo.getUnbox());
                            listVo.setOpeningTime(goodsSkuInfoVo.getOpeningTime());

                            if (listVo.getCreatedAt().isBefore(toCheckTime)) {// 15秒前创建的藏品，去主动核实发行交易状态
                                List<String> checkRespDataList = this.checkNftTradeFromGalaxy(uid, userDigitalArtworkVo.getOrderId(), goodsSkuInfoVo.getRouteType());
                                this.updateUserDigitalArtworkByChainTrade(userDigitalArtworkVo, listVo, checkRespDataList, now);
                            }

                            if (1 == userDigitalArtworkVo.getState() && "1".equals(goodsSkuInfoVo.getUnbox())) {// 盲盒已开启的，直接展示开出的藏品封面
                                GoblinNftOrderVo goblinNftOrder = goblinRedisUtils.getGoblinNftOrder(userDigitalArtworkVo.getOrderId());
                                goodsSkuInfoVo = goblinRedisUtils.getGoodsSkuInfoVo(goblinNftOrder.getBoxSkuId());
                                listVo.setCoverPic(goodsSkuInfoVo.getSkuPic());
                            }

                            list.add(listVo);
                        }
                    }

                    listVoPagedResult.setList(list).setTotal(artworkNum, pageSize);
                    pageVo.setArtworkNum((int) artworkNum).setPagedResult(listVoPagedResult);
                }
            }
        }
        return pageVo;
    }

    @Override
    public GoblinUserDigitalArtworkInfoVo info(String uid, String artworkId) {
        GoblinUserDigitalArtworkVo userDigitalArtworkVo = goblinRedisUtils.getUserDigitalArtworkVo(artworkId);
        if (null != userDigitalArtworkVo && userDigitalArtworkVo.getUid().equals(uid)) {
            GoblinUserDigitalArtworkInfoVo artworkInfoVo = GoblinUserDigitalArtworkInfoVo.getNew().copy(userDigitalArtworkVo);

            GoblinGoodsSkuInfoVo goodsSkuInfoVo = goblinRedisUtils.getGoodsSkuInfoVo(userDigitalArtworkVo.getSkuId());
            GoblinGoodsInfoVo goodsInfoVo = goblinRedisUtils.getGoodsInfoVo(goodsSkuInfoVo.getSpuId());

            artworkInfoVo.setName(goodsSkuInfoVo.getName());
            artworkInfoVo.setSubtitle(goodsSkuInfoVo.getSubtitle());
            artworkInfoVo.setMaterialType(goodsSkuInfoVo.getMaterialType());
            artworkInfoVo.setMaterialUrl(goodsSkuInfoVo.getMaterialUrl());
            artworkInfoVo.setEdition(goodsSkuInfoVo.getSkuStock());
            artworkInfoVo.setAuthor(goodsInfoVo.getAuthor());
            artworkInfoVo.setPublisher(goodsInfoVo.getPublisher());
            artworkInfoVo.setDetails(goodsSkuInfoVo.getDetails());

            return artworkInfoVo;
        }
        return null;
    }

    @Override
    public GoblinUserDigitalArtworkListVo unboxingForBuyOrExchange(String uid, GoblinUserDigitalArtworkVo userDigitalArtworkVo) {
        String orderId = userDigitalArtworkVo.getOrderId();
        GoblinNftOrderVo goblinNftOrder = goblinRedisUtils.getGoblinNftOrder(orderId);
        GoblinGoodsSkuInfoVo unboxSkuInfoVo = goblinRedisUtils.getGoodsSkuInfoVo(goblinNftOrder.getBoxSkuId());

        GoblinUserDigitalArtworkListVo unboxDigitalArtworkListVo = GoblinUserDigitalArtworkListVo.getNew();
//        unboxDigitalArtworkListVo.setArtworkId();
        unboxDigitalArtworkListVo.setName(unboxSkuInfoVo.getName());
        unboxDigitalArtworkListVo.setSubtitle(unboxSkuInfoVo.getSubtitle());
        unboxDigitalArtworkListVo.setCoverPic(unboxSkuInfoVo.getSkuPic());
//        unboxDigitalArtworkListVo.setSource(userDigitalArtworkVo.getSource());
//        unboxDigitalArtworkListVo.setState(0);
//        unboxDigitalArtworkListVo.setCreatedAt();
//        unboxDigitalArtworkListVo.setUnbox("0");
//        unboxDigitalArtworkListVo.setOpeningTime(now);

        LocalDateTime now = LocalDateTime.now();
        userDigitalArtworkVo.setState(1);
        userDigitalArtworkVo.setDelFlg("1");// 盲盒开启后直接删除
        userDigitalArtworkVo.setOpeningAt(now);
        userDigitalArtworkVo.setUpdatedAt(now);
        userDigitalArtworkVo.setDeletedAt(now);

//        if (goblinMongoUtils.updateUserDigitalArtworkVoByUnboxing(userDigitalArtworkVo)) {
            goblinRedisUtils.setexUserDigitalArtworkVo(userDigitalArtworkVo);

            String artworkId = userDigitalArtworkVo.getArtworkId();
            GoblinQueueBizArtworkGenDto queueBizArtworkGenDto = GoblinQueueBizArtworkGenDto.getNew();
            queueBizArtworkGenDto.setUid(uid);
            queueBizArtworkGenDto.setSkuId(unboxSkuInfoVo.getSkuId());
            queueBizArtworkGenDto.setOrderId(orderId);
            queueBizArtworkGenDto.setSource(userDigitalArtworkVo.getSource());
            queueBizArtworkGenDto.setFromArtId(artworkId);
            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.BIZ_ARTWORK_GEN.getKey(), queueBizArtworkGenDto.toJson());
            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_ARTWORK_GEN.getKey(),
                    SqlMapping.get("goblin_user_digital_artwork.update_for_unboxing", now, now, now, artworkId));
//        }
        return unboxDigitalArtworkListVo;
    }

    /* -------------------------------------------------------------------------------------------------------------- */
    /* -------------------------------------------------------------------------------------------------------------- */
    /* -------------------------------------------------------------------------------------------------------------- */

    private void updateUserDigitalArtworkByChainTrade(GoblinUserDigitalArtworkVo userDigitalArtworkVo, GoblinUserDigitalArtworkListVo listVo,
                                                      List<String> checkRespDataList, LocalDateTime now) {
        if (!CollectionUtils.isEmpty(checkRespDataList)) {
            String nftId = checkRespDataList.get(0);
            String nftPublishChainTimestamp = checkRespDataList.get(1);
            String nftPublishTxHash = checkRespDataList.get(2);
            String nftBuyChainTimestamp = checkRespDataList.get(3);
            String nftBuyTxHash = checkRespDataList.get(4);

            listVo.setState(1);
            listVo.setEditionSn(Integer.valueOf(nftId.substring(nftId.indexOf("_") + 1)));

            userDigitalArtworkVo.setEditionSn(listVo.getEditionSn());
            userDigitalArtworkVo.setNftId(nftId);
            userDigitalArtworkVo.setReleaseAt(nftPublishChainTimestamp);
            userDigitalArtworkVo.setReleaseTxhash(nftPublishTxHash);
            userDigitalArtworkVo.setTradingAt(nftBuyChainTimestamp);
            userDigitalArtworkVo.setTradingTxhash(nftBuyTxHash);
            userDigitalArtworkVo.setState(1);
            userDigitalArtworkVo.setUpdatedAt(now);

            goblinRedisUtils.setUserDigitalArtworkVo(userDigitalArtworkVo);
            goblinMongoUtils.updateUserDigitalArtworkVoByChainTrade(userDigitalArtworkVo);

            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_ARTWORK_GEN.getKey(),
                    SqlMapping.get("goblin_user_digital_artwork.update_for_chain",
                            userDigitalArtworkVo.getEditionSn(), userDigitalArtworkVo.getNftId(), userDigitalArtworkVo.getReleaseTxhash(),
                            userDigitalArtworkVo.getReleaseAt(), userDigitalArtworkVo.getTradingTxhash(), userDigitalArtworkVo.getTradingAt(),
                            userDigitalArtworkVo.getState(), userDigitalArtworkVo.getUpdatedAt())
            );
        }
    }

    private List<String> checkNftTradeFromGalaxy(String uid, String orderId, String routerType) {
        LinkedMultiValueMap<String, String> paramsMap = CollectionUtil.linkedMultiValueMapStringString();
        paramsMap.add("userId", uid);
        paramsMap.add("nftOrderPayId", orderId);// TODO: 2022/3/31 ==zhanggb
        paramsMap.add("routerType", routerType);

//        String postUrl = sevGalaxyUrl + "/user/register", blockChainAddress;// TODO: 2022/3/31 ==zhanggb
        String postUrl = "https://ENVgalaxy.zhengzai.tv/galaxy/nftTrade/nftPublishAndBuyResultQuery".replace("ENV", env.getProperty(CurrentUtil.CK_ENV_ACTIVE)), blockChainAddress;
        try {
            LinkedMultiValueMap<String, String> headerMap = CollectionUtil.linkedMultiValueMapStringString();
            headerMap.add("Accept", MediaType.APPLICATION_JSON_VALUE);
            String postRespStr = HttpUtil.post(postUrl, paramsMap, headerMap);
            JsonNode postRespJNode = JsonUtils.fromJson(postRespStr, JsonNode.class);
            if (null == postRespJNode || !postRespJNode.get("code").asText().equals("0")) {
                log.warn("#NFT发行购买结果查询:查询失败[paramsMap={},postRespStr={}]", paramsMap, postRespStr);
                return null;
            }
            JsonNode postRespDataJNode = postRespJNode.get("data");

            List<String> respDataList = CollectionUtil.arrayListString();
            respDataList.add(postRespDataJNode.get("nftId").asText());
            respDataList.add(postRespDataJNode.get("nftPublishChainTimestamp").asText());
            respDataList.add(postRespDataJNode.get("nftPublishTxHash").asText());
            respDataList.add(postRespDataJNode.get("nftBuyChainTimestamp").asText());
            respDataList.add(postRespDataJNode.get("nftBuyTxHash").asText());
            return respDataList;
        } catch (Exception e) {
            log.error("Ex.NFT发行购买结果查询:请求异常[UID={},url={},paramsMap={}],ex:{}", uid, postUrl, paramsMap, e.getMessage());
            return null;
        }
    }
}
