package com.liquidnet.service.goblin.param;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Api
@Data
public class CouponHelpUseParam implements Serializable, Cloneable {
    @ApiModelProperty(name = "param", value = "对象", required = true)
    @NotNull
    @NotBlank
    private List<CouponCanUse2Param> param;
    @ApiModelProperty(dataType = "String", name = "uid", value = "用户id", example = "10", required = false)
    private String uid;
    @ApiModelProperty(dataType = "String", name = "ucouponId", value = "店铺券id", required = false)
    private String ucouponId;
    @ApiModelProperty(dataType = "String", name = "platformUcouponId", value = "平台券id", required = false)
    private String platformUcouponId;

    private static final CouponHelpUseParam obj = new CouponHelpUseParam();

    public static CouponHelpUseParam getNew() {
        try {
            return (CouponHelpUseParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new CouponHelpUseParam();
    }

}
