package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@ApiModel(value = "AdamTagVo", description = "标签库")
public class AdamTagVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 5852327873275898342L;
    @ApiModelProperty(position = 11, value = "标签Key")
    private String val;
    @ApiModelProperty(position = 12, value = "标签名称")
    private String desc;

    private static final AdamTagVo obj = new AdamTagVo();

    public static AdamTagVo getNew() {
        try {
            return (AdamTagVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamTagVo();
    }

    public String getVal() {
        return val;
    }

    public AdamTagVo setVal(String val) {
        this.val = val;
        return this;
    }

    public String getDesc() {
        return desc;
    }

    public AdamTagVo setDesc(String desc) {
        this.desc = desc;
        return this;
    }
}
