package com.liquidnet.service.goblin.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.param.GoblinNowOrderListParam;

import java.util.List;

public interface IGoblinStoreZhengzaiService {

    /**
     * 正在下单活动列表
     *
     * @return
     */
    ResponseDto<List<GoblinSelfMarketingVo>> getZhengzaiMarketList();

    /**
     * 正在下单 商铺参与活动的商品列表
     * @param marketId
     * @param keyword 搜索关键字，支持搜索`SPU名称`
     * @return
     */
    ResponseDto<List<GoblinZhengzaiGoodVo>> getSpuList(String marketId, String keyword);

    ResponseDto<GoblinZhengzaiGoodPageVo> getSpuList2(String marketId, String keyword, Integer page);

    ResponseDto<List<GoblinAppOrderListVo>> orderList(int page);

    ResponseDto<Boolean> orderPush(String orderMasterCode);

    ResponseDto<List<GoblinNowOrderListVo>> nowOrderList(GoblinNowOrderListParam param);

    ResponseDto<GoblinAppOrderDetailsVo> nowOrderDetails(GoblinNowOrderListParam param);
}
