package com.liquidnet.common.exception;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: liquid global Exception
 * @class: LiquidnetServiceException
 * @Package com.liquidnet.common.exception
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/9/21 10:37
 */
public class LiquidnetServiceException extends RuntimeException {
    private static final long serialVersionUID = -4836329430647395511L;
    private String code;
    private String message;
    private Object data;

    public LiquidnetServiceException() {
    }

    public LiquidnetServiceException(String code, String message) {
        super(message);
        this.code = code;
        this.message = message;
    }

    public LiquidnetServiceException(String code, String message, Object data) {
        super(message);
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }
}
