package com.liquidnet.service.kylin.dto.param;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.entity.KylinFieldRelations;
import com.liquidnet.service.kylin.entity.KylinFieldStatus;
import com.liquidnet.service.kylin.entity.KylinFields;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * 修改场地全部显示数据参数
 */
@Data
public class FieldsParam implements Serializable {
    @ApiModelProperty(value = "场地主键", example = "测试场地")
    private String fieldsId;

    @ApiModelProperty(value = "场地名称", example = "测试场地")
    private String name;

    @ApiModelProperty(value = "英文名", example = "ceshi")
    private String nameEng;

    @ApiModelProperty(value = "拼音", example = "ceshi")
    private String pinyin;

    @ApiModelProperty(value = "封面图", example = "https://img.zhengzai.tv/partner/2019/05/14/5cda2d0520177.png")
    private String coverImg;

    @ApiModelProperty(value = "详细地址", example = "北京市北京朝阳区摩登天空")
    private String address;

    @ApiModelProperty(value = "经度", example = "100.00")
    private String longitude;

    @ApiModelProperty(value = "纬度", example = "100.00")
    private String latitude;

    @ApiModelProperty(value = "联系电话", example = "15901093014")
    private String phone;

    @ApiModelProperty(value = "描述", example = "这是一个描述")
    private String description;

    @ApiModelProperty(value = "省id", example = "1")
    private int provinceId;

    @ApiModelProperty(value = "省名称", example = "北京")
    private String provinceName;

    @ApiModelProperty(value = "城市id", example = "1")
    private int cityId;

    @ApiModelProperty(value = "城市名称", example = "北京")
    private String cityName;

    @ApiModelProperty(value = "县id", example = "1")
    private int districtId;

    @ApiModelProperty(value = "县名称", example = "朝阳区")
    private String districtName;

    @ApiModelProperty(value = "拒绝理由", example = "")
    private String refuseMessage;

//    @ApiModelProperty(value = "认证状态 0未认证 1已认证", example = "0")
//    @JsonIgnore
//    private int validStatus;
//
//    @ApiModelProperty(value = "是否显示 0不显示 1显示", example = "1")
//    @JsonIgnore
//    private int isDisplay;
//
//    @ApiModelProperty(value = "是否营业 0不营业 1营业中", example = "1")
//    @JsonIgnore
//    private int isBusiness;
//
//    @ApiModelProperty(value = "审核状态 0待审核 1已审核 2被拒绝", example = "0")
//    @JsonIgnore
//    private int changeStatus;

    @ApiModelProperty(value = "补充字段", example = "")
    private String comment;

    @JsonIgnore
    public KylinFields getFields(String fieldsId, LocalDateTime createdAt) {
        KylinFields fields = new KylinFields();
        BeanUtils.copyProperties(this, fields);
        if (null != fieldsId) {
            fields.setFieldsId(fieldsId);
        }
        if (null != createdAt) {
            fields.setCreatedAt(createdAt);
        }
        return fields;
    }

    @JsonIgnore
    public KylinFieldStatus getFieldStatus(String fieldsId, LocalDateTime createdAt, int validStatus, int isDisplay, int isBusiness, int changeStatus) {
        KylinFieldStatus fieldStatus = new KylinFieldStatus();
        BeanUtils.copyProperties(this, fieldStatus);
        fieldStatus.setFieldStatusId(IDGenerator.nextSnowId().toString());
        fieldStatus.setFieldId(fieldsId);
        fieldStatus.setValidStatus(validStatus);
        fieldStatus.setIsDisplay(isDisplay);
        fieldStatus.setIsBusiness(isBusiness);
        fieldStatus.setChangeStatus(changeStatus);
        fieldStatus.setCreatedAt(createdAt);
        return fieldStatus;
    }

    @JsonIgnore
    public KylinFieldRelations getFieldRelations(String fieldsId, LocalDateTime createdAt) {
        KylinFieldRelations fieldRelations = new KylinFieldRelations();
        BeanUtils.copyProperties(this, fieldRelations);
        fieldRelations.setFieldRelationsId(IDGenerator.nextSnowId().toString());
        fieldRelations.setFieldId(fieldsId);
        fieldRelations.setCreatedAt(createdAt);
        return fieldRelations;
    }
}
