package com.liquidnet.service.kylin.controller.admin;

import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.kylin.dto.param.FieldsParam;
import com.liquidnet.service.kylin.dto.param.FieldsSearchParam;
import com.liquidnet.service.kylin.dto.vo.FieldsVo;
import com.liquidnet.service.kylin.service.impl.FieldsServiceImpl;
import com.liquidnet.service.kylin.service.impl.admin.FieldsAdminServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api
@RestController
@RequestMapping("/admin/fields")
public class FieldsAdminController {

    @Autowired
    private FieldsAdminServiceImpl fieldsAdminService;

    @PostMapping(value = "")
    @ApiOperation(value = "创建场地")
    @ApiResponse(response = FieldsVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<FieldsVo> createFields(@RequestBody FieldsParam fieldsParam) {
        boolean result=fieldsAdminService.fieldCreate(fieldsParam);
        if(result) {
            return ResponseDto.success();
        }else{
            return ResponseDto.failure("场地创建失败");
        }
    }

    @PutMapping(value = "")
    @ApiOperation(value = "mis修改场地全部数据")
    @ApiResponse(response = FieldsVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<FieldsVo> fieldUpdate(@RequestBody FieldsParam fieldsParam) {
        boolean result=fieldsAdminService.fieldUpdateMessage(fieldsParam);
        if(result) {
            return ResponseDto.success();
        }else{
            return ResponseDto.failure("修改场地失败");
        }
    }

    @PostMapping(value = "list")
    @ApiOperation(value = "mis获取场地列表")
    @ApiResponse(response = FieldsVo.class, code = 200, message = "接口返回对象参数")
    public void fieldList(@RequestBody FieldsSearchParam fieldsSearchParam) {
        boolean result=fieldsAdminService.fieldList(fieldsSearchParam);
        if(result) {
//            return ResponseDto.success("成功");
        }else{
//            return ResponseDto.failure("修改场地失败");
        }
    }
}
