package com.liquidnet.service.kylin.service.impl.admin;


import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.param.FieldsParam;
import com.liquidnet.service.kylin.dto.param.FieldsSearchParam;
import com.liquidnet.service.kylin.dto.vo.FieldsVo;
import com.liquidnet.service.kylin.entity.KylinFields;
import com.liquidnet.service.kylin.mapper.KylinFieldRelationMapper;
import com.liquidnet.service.kylin.mapper.KylinFieldStatusMapper;
import com.liquidnet.service.kylin.mapper.KylinFieldsMapper;
import com.liquidnet.service.kylin.service.admin.KylinFieldsAdminService;
import com.mongodb.BasicDBObject;
import com.mongodb.client.result.UpdateResult;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Service
public class FieldsAdminServiceImpl implements KylinFieldsAdminService {

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private KylinFieldsMapper fieldsMapper;

    @Autowired
    private KylinFieldStatusMapper kylinFieldStatusMapper;

    @Autowired
    private KylinFieldRelationMapper fieldRelationsMapper;

    /**
     * mis修改场地全部数据
     *
     * @param fieldsParam
     * @return
     */
    @Override
    public boolean fieldUpdateMessage(FieldsParam fieldsParam) {
        try {
            String fieldsId = fieldsParam.getFieldsId();
            // mysql 操作
            fieldsMapper.update(fieldsParam.getFields(null, null)
                    , new UpdateWrapper<KylinFields>().eq("fields_id", fieldsId));

            // mongo 操作
            FieldsVo fieldsVo = new FieldsVo();
            BeanUtils.copyProperties(fieldsParam, fieldsVo);
            fieldsVo.setFieldsId(fieldsId);

            BasicDBObject object = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(fieldsVo)));
            UpdateResult updateRst = mongoTemplate.getCollection(FieldsVo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("fieldsId").is(fieldsId)).getQueryObject(), object
            );

            // redis 操作
            redisUtil.hset(KylinRedisConst.FIELDS, fieldsId, fieldsVo);
            return true;

        } catch (Exception e) {
            return false;
        }
    }

    /**
     * 创建场地
     *
     * @param fieldsParam
     * @return boolean
     */
    @Override
    @Transactional
    public boolean fieldCreate(FieldsParam fieldsParam) {
        try {
            // 获取 主键id
            String fieldsId = IDGenerator.nextSnowId().toString();
            // 获取 当前时间 -> 创建时间
            LocalDateTime createdAt = LocalDateTime.now();

            // mysql 操作
            fieldsMapper.insert(fieldsParam.getFields(fieldsId, createdAt));
            kylinFieldStatusMapper.insert(fieldsParam.getFieldStatus(fieldsId, createdAt, 1, 1, 1, 1));
            fieldRelationsMapper.insert(fieldsParam.getFieldRelations(fieldsId, createdAt));

            // mongo 操作
            FieldsVo fieldsVo = new FieldsVo();
            BeanUtils.copyProperties(fieldsParam, fieldsVo);
            fieldsVo.setFieldsId(fieldsId);
            fieldsVo.setCreatedAt(createdAt);
            Collection<FieldsVo> insertRst = mongoTemplate.insert(
                    Collections.singletonList(fieldsVo), FieldsVo.class.getSimpleName()
            );

            // redis 操作
            redisUtil.hset(KylinRedisConst.FIELDS, fieldsId, fieldsVo);

            return true;
        } catch (Exception e) {
            return false;
        }
    }

    /**
     * 场地列表 - 条件查询
     *
     * @param fieldsSearchParam
     * @return
     */
    @Override
    public boolean fieldList(FieldsSearchParam fieldsSearchParam) {
        try {
            fieldsSearchParam.setCityId(0);
            fieldsSearchParam.setDistrictId(0);
            fieldsSearchParam.setProvinceId(0);
            Map data=fieldsMapper.misSearchFields(BeanUtil.convertBeanToMap(fieldsSearchParam));
            System.out.println("DATA = "+data.toString());
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    /**
     * 场地详情
     *
     * @param fieldsParam
     * @return
     */
    @Override
    public boolean fieldDetails(FieldsParam fieldsParam) {
        return false;
    }

    /**
     * 场地审核
     *
     * @param fieldsParam
     * @return
     */
    @Override
    public boolean fieldAudit(FieldsParam fieldsParam) {
        return false;
    }
}
