package com.liquidnet.service.adam.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@EqualsAndHashCode(callSuper = false)
public class AdamMemberOrder implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 订单号
     */
    private String orderNo;
    /**
     * 用户id
     */
    private String uid;
    /**
     * 购买方式:0-购买会员 1-购买会员码,2-使用会员码
     */
    private Integer mode;
    /**
     * 原价
     */
    private BigDecimal price;
    /**
     * 实际支付价格
     */
    private BigDecimal pricePaid;
    /**
     * 会员名称
     */
    private String memberName;
    /**
     * 会员id
     */
    private String memberId;
    /**
     * 价格id
     */
    private String memberPriceId;
    /**
     * 购买天数
     */
    private Integer days;
    /**
     * 订单状态:0未支付 1已支付 2已超时 5已退款
     */
    private Integer state;
    /**
     * 会员编号
     */
    private String memberNo;
    /**
     * 会员生日[yyyy-MM-dd]
     */
    private String birthday;
    /**
     * 地区
     */
    private String area;
    /**
     * 支付终端:app,wap,js,applet
     */
    private String deviceFrom;
    /**
     * 支付方式:alipay,wepay,vipcode,giftcode
     */
    private String payType;
    /**
     * 支付中心支付CODE
     */
    private String payNo;
    /**
     * 支付中心三方支付ID
     */
    private String paymentId;
    /**
     * 支付时间
     */
    private LocalDateTime paymentAt;
    private LocalDateTime createdAt;
    private LocalDateTime updatedAt;
    /**
     * ip地址
     */
    private String clientIp;
    /**
     * 购买来源  Android  iOS  h5
     */
    private String source;
    /**
     * 客户端版本号
     */
    private String version;
    private String comment;


}
