package com.liquidnet.service.goblin.service.impl;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.vo.AnticipateValueVo;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.service.GoblinCouponService;
import com.liquidnet.service.goblin.service.IGoblinNftGoodsAppService;
import com.liquidnet.service.goblin.service.manage.IGoblinGoodsAnticipateMgService;
import com.liquidnet.service.goblin.util.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Service
@Slf4j
public class GoblinNftGoodsAppServiceImpl implements IGoblinNftGoodsAppService {

    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    GoblinMongoUtils mongoUtils;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    private GoblinOrderUtils goblinOrderUtils;
    @Autowired
    GoblinCouponService goblinCouponService;
    @Autowired
    IGoblinGoodsAnticipateMgService goblinGoodsAnticipateMgService;

    final static int size = 20;

    @Override
    public ResponseDto<PagedResult<GoblinNftGoodsSkuListVo>> goodsList(int page) {
        List<String> startSkuIdList = goblinRedisUtils.getGoblinNftGoodsInfoListVo("1");
        List<String> notStartSkuIdList = goblinRedisUtils.getGoblinNftGoodsInfoListVo("2");
        List<String> soldOutSkuIdList = goblinRedisUtils.getGoblinNftGoodsInfoListVo("3");
        List<String> allIdList = Stream.of(startSkuIdList, notStartSkuIdList, soldOutSkuIdList).flatMap(Collection::stream).collect(Collectors.toList());

        int finalCount = (page - 1) * size;
        int initCount = page * size;
        if (finalCount < 0) {
            finalCount = 0;
        }
        int allSize = allIdList.size();
        if (initCount > allSize) {
            initCount = allSize;
        }
        List<GoblinNftGoodsSkuListVo> skuList = ObjectUtil.getGoblinNftGoodsSkuListVoArrayList();
        HashMap<String, Object> spuInfoList = CollectionUtil.mapStringObject();
        for (int i = finalCount; i < initCount; i++) {
            String skuId = allIdList.get(i);
            // sku信息
            GoblinGoodsSkuInfoVo skuInfoVo = goblinRedisUtils.getGoodsSkuInfoVo(skuId);
            GoblinNftGoodsSkuListVo goblinNftGoodsSkuListVo = GoblinNftGoodsSkuListVo.getNew().copy(skuInfoVo);
            // spu信息
            Object spuInfoMap = spuInfoList.get(skuInfoVo.getSpuId());
            if (null == spuInfoMap) {
                GoblinGoodsInfoVo goodsInfoVo = goblinRedisUtils.getGoodsInfoVo(skuInfoVo.getSpuId());
                GoblinNftGoodsSpuInfoVo nftGoodsSpuInfoVo = GoblinNftGoodsSpuInfoVo.getNew().copy(goodsInfoVo);
                spuInfoList.put(skuInfoVo.getSpuId(), nftGoodsSpuInfoVo);
                goblinNftGoodsSkuListVo.setGoblinNftGoodsSpuInfoVo(nftGoodsSpuInfoVo);
            } else {
                goblinNftGoodsSkuListVo.setGoblinNftGoodsSpuInfoVo((GoblinNftGoodsSpuInfoVo) spuInfoMap);
            }
            // 库存、预约
            if (soldOutSkuIdList.contains(skuId)) {// 是售罄的
                goblinNftGoodsSkuListVo.setIsStock(0);
            } else {
                goblinNftGoodsSkuListVo.setIsStock(1);
                // 获取预约相关 未售罄的才查询预约
                AnticipateValueVo anticipateValueVo = goblinGoodsAnticipateMgService.getAnticipateValueBySkuId(skuId, 0);
                goblinNftGoodsSkuListVo.setAnticipateValueVo(anticipateValueVo);
            }
            // 写入列表
            skuList.add(goblinNftGoodsSkuListVo);
        }

        PagedResult<GoblinNftGoodsSkuListVo> listVoPagedResult = ObjectUtil.getGoblinNftGoodsSkuListVoPagedResult();
        listVoPagedResult.setList(skuList).setPageSize(GoblinNftGoodsAppServiceImpl.size).setCurrentPage(page);
        return ResponseDto.success(listVoPagedResult);
    }

    @Override
    public GoblinNftGoodsSkuInfoVo goodsDetail(String skuId) {
        GoblinGoodsSkuInfoVo skuInfoVo = goblinRedisUtils.getGoodsSkuInfoVo(skuId);
        if (goblinRedisUtils.getSkuAllStatusShow(skuInfoVo)) {
            //获取预约相关
            AnticipateValueVo anticipateValueVo = goblinGoodsAnticipateMgService.getAnticipateValueBySkuId(skuId, 1);

            GoblinNftGoodsSkuInfoVo nftGoodsSkuInfoVo = GoblinNftGoodsSkuInfoVo.getNew().copy(skuInfoVo, anticipateValueVo);
            // 限购数量
            Integer buyCount = 0;
            String userId = CurrentUtil.getCurrentUid();
            if (StringUtils.isNotBlank(userId)) {
                buyCount = goblinRedisUtils.getSkuCountByUid(userId, skuId);
            }
            if (null != skuInfoVo.getBuyLimit() && 0 != skuInfoVo.getBuyLimit()) {
                nftGoodsSkuInfoVo.setCanBuyNum(skuInfoVo.getBuyLimit() - buyCount);
            }
            // spu信息
            GoblinGoodsInfoVo goodsInfoVo = goblinRedisUtils.getGoodsInfoVo(skuInfoVo.getSpuId());
            GoblinNftGoodsDetailSpuInfoVo nftGoodsDetailSpuInfoVo = GoblinNftGoodsDetailSpuInfoVo.getNew().copy(goodsInfoVo);
            nftGoodsSkuInfoVo.setGoblinNftGoodsDetailSpuInfoVo(nftGoodsDetailSpuInfoVo);
            // 库存
            HashMap<String, Integer> stockHashMap = goblinOrderUtils.getIsStock(skuId, skuInfoVo.getUnbox(), skuInfoVo.getSoldoutStatus(), goodsInfoVo.getSkuIdList());
            nftGoodsSkuInfoVo.setIsStock(stockHashMap.get("isStock"));
            // 总库存
            if (skuInfoVo.getUnbox().equals("1")) {
                nftGoodsSkuInfoVo.setSkuStock(stockHashMap.get("totalStock"));
            }
            // 系统时间
            nftGoodsSkuInfoVo.setSystime(LocalDateTime.now());
            // 是否开启兑换
            // TODO: jxl 2022/4/26
            nftGoodsSkuInfoVo.setIsExchange(2);
            return nftGoodsSkuInfoVo;
        } else {
            return null;
        }
    }

}
