package com.liquidnet.service.feign.kylin.task;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

@Component
@FeignClient(name = "liquidnet-service-platform",
        contextId = "FeignPlatformAlipayBackClient", path = "",
        url = "",
        fallback = FallbackFactory.Default.class)
public interface FeignPlatformAlipayBackClient {

    @GetMapping("platform/refund/alipayActiveCallback")
    ResponseDto<String> alipayActiveCallback();

}
