package com.liquidnet.client.admin.zhengzai.kylin.dto;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.service.kylin.dao.CommodityOrderExportDao;
import lombok.Data;

import java.io.Serializable;

@Data
public class OrderCommodityExportVo implements Serializable, Cloneable {

    @Excel(name = "商户订单号", cellType = Excel.ColumnType.STRING)
    private String code;
    @Excel(name = "微信/支付宝订单号", cellType = Excel.ColumnType.STRING)
    private String paymentId;
    @Excel(name = "商品名称", cellType = Excel.ColumnType.STRING)
    private String name;
    @Excel(name = "支付平台", cellType = Excel.ColumnType.STRING)
    private String paymentType;
    @Excel(name = "实际支付价格", cellType = Excel.ColumnType.STRING)
    private String priceActual;
    @Excel(name = "创建时间", cellType = Excel.ColumnType.STRING)
    private String createdAt;
    @Excel(name = "快递费", cellType = Excel.ColumnType.STRING)
    private String priceExpress;
    @Excel(name = "退款价格", cellType = Excel.ColumnType.STRING)
    private String priceRefund;
    @Excel(name = "状态", cellType = Excel.ColumnType.STRING)
    private String status;
    @Excel(name = "退款时间", cellType = Excel.ColumnType.STRING)
    private String refundAt;


    private static final OrderCommodityExportVo obj = new OrderCommodityExportVo();

    public static OrderCommodityExportVo getNew() {
        try {
            return (OrderCommodityExportVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new OrderCommodityExportVo();
    }

    public OrderCommodityExportVo copyCommodityOrderExportVo(CommodityOrderExportDao source) {
        this.setCode(source.getCode());
        this.setPaymentId(source.getPaymentId());
        this.setName(source.getName());
        this.setPaymentType(source.getPaymentType());
        this.setPriceActual(source.getPriceActual());
        this.setCreatedAt(source.getCreatedAt());
        this.setPriceExpress(source.getPriceExpress());
        this.setPriceRefund(source.getPriceRefund());
        this.setStatus(source.getStatus());
        this.setRefundAt(source.getRefundAt());
        return this;
    }


}
