package com.liquidnet.service.kylin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;


@Data
@ApiModel(value = "福袋VO")
public class KylinLuckyBagVo implements Serializable {

    @ApiModelProperty(value = "福袋列表")
    private List<LuckyBagVo> luckyBagVoList;

    @ApiModelProperty(value = "福袋活动列表")
    private List<LuckyBagActivityVo> luckyBagActivityVoList;

    @Data
    @ApiModel(value = "福袋活动VO")
    public static class LuckyBagActivityVo {

        @ApiModelProperty(value = "活动ID")
        private String luckyBagActivityId;

        @ApiModelProperty(value = "活动名称")
        private String name;

        @ApiModelProperty(value = "活动简介")
        private String detail;

        @ApiModelProperty(value = "跳转地址")
        private String targetUrl;
    }

    @Data
    @ApiModel(value = "福袋VO")
    public static class LuckyBagVo {

        @ApiModelProperty(value = "福袋ID")
        private String luckyBagId;

        @ApiModelProperty(value = "福袋名称")
        private String name;

        @ApiModelProperty(value = "福袋描述")
        private String introduction;

        @ApiModelProperty(value = "状态 0：未解锁  1：已解锁")
        private int status;

        @ApiModelProperty(value = "兑换码")
        private List<String> rewardCodeList;
    }
}
