package com.liquidnet.service.kylin.controller;

import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.KylinLuckyBagVo;
import com.liquidnet.service.kylin.service.IKylinLuckyBagService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "前端-获取福袋相关")
@RestController
@RequestMapping("/luckyBag")
@Slf4j
public class KylinLuckyBagController {

    @Autowired
    private IKylinLuckyBagService benefitsService;


    @GetMapping("")
    @ApiOperation("获取福袋权益列表")
    public ResponseDto<KylinLuckyBagVo> getLuckyBagBenefitsByOrderId(@RequestParam(value = "orderId") String orderId) {

        String jsonObj = "{\n" +
                "    \"luckyBagVoList\": [\n" +
                "        {\n" +
                "            \"luckyBagId\": \"bag001\",\n" +
                "            \"name\": \"蛋仔派对专属皮肤\",\n" +
                "            \"introduction\": \"1. 每个观演人对应发放一张兑换券/n 2. 兑换券为虚拟商品，一旦丢失或泄露，可能被他人使用，请妥善保管/n 3. 兑换码有效期至[具体日期]，请及时使用。\",\n" +
                "            \"status\": 1,\n" +
                "            \"rewardCodeList\": [\n" +
                "                \"CODE123\",\n" +
                "                \"CODE456\"\n" +
                "            ]\n" +
                "        },\n" +
                "        {\n" +
                "            \"luckyBagId\": \"bag002\",\n" +
                "            \"name\": \"蛋仔派对新地图\",\n" +
                "            \"introduction\": \"未解锁的福袋，快来领取吧！\",\n" +
                "            \"status\": 0,\n" +
                "            \"rewardCodeList\": []\n" +
                "        }\n" +
                "    ],\n" +
                "    \"luckyBagActivityVoList\": [\n" +
                "        {\n" +
                "            \"luckyBagActivityId\": \"activity002\",\n" +
                "            \"name\": \"本单权益\",\n" +
                "            \"detail\": \"福袋活动详情\",\n" +
                "            \"targetUrl\": \"https://baidu.com\"\n" +
                "        }\n" +
                "    ]\n" +
                "}";
        return ResponseDto.success(JsonUtils.fromJson(jsonObj, KylinLuckyBagVo.class));

//        return ResponseDto.success(benefitsService.getLuckyBagBenefitsByOrderId(orderId));
    }
}
