package com.liquidnet.service.goblin.dto.manage;

import com.liquidnet.commons.lang.constant.LnsRegex;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreCouponBasicVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "GoblinStoreMgtCouponAddParam", description = "商铺活动:添加优惠券入参")
@Data
public class GoblinStoreMgtCouponAddParam implements Serializable {
    private static final long serialVersionUID = 4211658816582135860L;
    @ApiModelProperty(position = 10, required = true, value = "店铺ID")
    @NotNull(message = "店铺ID不能为空")
    private String storeId;
    @ApiModelProperty(position = 11, required = false, value = "优惠券ID[编辑时必传]")
    private String storeCouponId;

    /**
     * ---------------------------- 基本信息 ----------------------------
     **/

    @ApiModelProperty(position = 12, required = true, value = "卡券名称[50]", example = "DEV_CESHI")
    @NotBlank(message = "卡券名称不能为空")
    @Size(max = 50, message = "商品名称长度超限")
    private String title;
    @ApiModelProperty(position = 13, required = false, value = "标注[50]")
    @Size(max = 50, message = "标注长度超限")
    private String label;
    @ApiModelProperty(position = 14, required = false, value = "卡券描述[255]")
    @Size(max = 255, message = "卡券描述长度超限")
    private String notice;

    @ApiModelProperty(position = 15, required = true, value = "开始时间[yyyy-MM-dd HH:mm:ss]", example = "2022-12-01 00:00:00")
    @NotBlank(message = "发布时间不能为空")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "开始时间格式有误")
    private String startTime;
    @ApiModelProperty(position = 16, required = true, value = "开始时间[yyyy-MM-dd HH:mm:ss]", example = "2022-12-01 00:00:00")
    @NotBlank(message = "发布时间不能为空")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "开始时间格式有误")
    private String endTime;


    @ApiModelProperty(position = 10, required = true, value = "券类型[1-代金券|2-折扣券|3-满减券]", allowableValues = "1,2,3", example = "1")
    @NotNull(message = "券类型不能为空")
    @Pattern(regexp = "\\b(1|2|3)\\b", message = "券类型参数无效")
    private String type;//
    @ApiModelProperty(position = 11, required = true, value = "卡券库存，默认：0为无限", example = "0")
    @NotNull(message = "卡券库存不能为空")
    @Min(value = 0, message = "卡券库存不能小于0")
    private Integer stock;
    @ApiModelProperty(position = 12, required = true, value = "触发金额[8,2]", example = "1")
    @DecimalMin(value = "0.01", message = "触发金额不能小于0.01")
    private BigDecimal triggers;
    @ApiModelProperty(position = 12, required = false, value = "面值[8,2]", example = "5")
    @DecimalMin(value = "0.01", message = "面值不能小于0.01")
    private BigDecimal valFace;
    @ApiModelProperty(position = 12, required = false, value = "折扣[8,2]", example = "0.8")
    @DecimalMin(value = "0.01", message = "折扣不能小于0.01")
    private BigDecimal discount;
    @ApiModelProperty(position = 12, required = false, value = "满减~满[8,2]", example = "10")
    @DecimalMin(value = "0.02", message = "满减金额不能小于0.02")
    private BigDecimal valOver;
    @ApiModelProperty(position = 12, required = false, value = "满减~减[8,2]", example = "5")
    @DecimalMin(value = "0.01", message = "满减面额不能小于0.01")
    private BigDecimal valMinus;
    @ApiModelProperty(position = 12, required = false, value = "抵扣上限金额[8,2]", example = "2")
    @DecimalMin(value = "0.01", message = "抵扣上限金额不能小于0.01")
    private BigDecimal deduction;


    @ApiModelProperty(position = 18, required = true, value = "限领数量，默认：1张/人", example = "1")
    @NotNull(message = "限领数量不能为空")
    @Min(value = 1, message = "限领数量不能小于1")
    private Integer receiveLimit;
    @ApiModelProperty(position = 19, required = true, value = "领取约束[0-不开放|1-开放]", allowableValues = "0,1", example = "1")
    @NotNull(message = "领取约束不能为空")
    @Pattern(regexp = "\\b(0|1)\\b", message = "领取约束参数无效")
    private String receiveCurb;//

    /**
     * ---------------------------- 发放设置 ----------------------------
     **/

    @ApiModelProperty(position = 20, required = true, value = "使用范围[0-全部商品|1-部分商品]", allowableValues = "0,1", example = "0")
    @NotNull(message = "使用范围不能为空")
    @Pattern(regexp = "\\b(0|1)\\b", message = "使用范围参数无效")
    private String useScope;//
    @ApiModelProperty(position = 21, required = false, value = "适用SPUID集合LIST")
    private List<String> spuIdList;
//    private List<GoblinStoreMgtCouponAddGoods> skuParamList;


    public GoblinStoreCouponBasicVo initStoreCouponBasicInfo() {
        GoblinStoreCouponBasicVo storeCouponBasicVo = GoblinStoreCouponBasicVo.getNew();
//        storeCouponBasicVo.setStoreCouponId();
//        storeCouponBasicVo.setStoreCouponNo();
        storeCouponBasicVo.setStoreId(this.getStoreId());
        storeCouponBasicVo.setTitle(this.getTitle());
        storeCouponBasicVo.setLabel(this.getLabel());
        storeCouponBasicVo.setNotice(this.getNotice());
        storeCouponBasicVo.setType(this.getType());
        storeCouponBasicVo.setStock(this.getStock());
        storeCouponBasicVo.setTriggers(this.getTriggers());
//        storeCouponBasicVo.setValFace();
//        storeCouponBasicVo.setDiscount();
//        storeCouponBasicVo.setValOver();
//        storeCouponBasicVo.setValMinus();
//        storeCouponBasicVo.setDeduction();
        storeCouponBasicVo.setReceiveLimit(this.getReceiveLimit());
        storeCouponBasicVo.setReceiveCurb(this.getReceiveCurb());
        storeCouponBasicVo.setUseScope(this.getUseScope());
        storeCouponBasicVo.setState("0");// 等待开始
        storeCouponBasicVo.setStartTime(DateUtil.Formatter.yyyyMMddHHmmss.parse(this.getStartTime()));
        storeCouponBasicVo.setEndTime(DateUtil.Formatter.yyyyMMddHHmmss.parse(this.getEndTime()));
        storeCouponBasicVo.setSpuIdList(this.getUseScope().equals("1") ? this.getSpuIdList() : null);
        return storeCouponBasicVo;
    }
}
