package com.liquidnet.client.admin.web.controller.zhengzai.smile;


import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileAgentService;
import com.liquidnet.service.smile.entity.SmileAgent;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-16
 */
@Api(tags = "代理配置")
@RestController
@RequestMapping("/smile/agent")
public class SmileAgentController {

    @Autowired
    ISmileAgentService smileAgentService;

    @PostMapping("/list")
    @ApiOperation("获取票提")
    @ResponseBody
    public AjaxResult organizationList(@RequestBody SmileAgent smileAgent){
        return AjaxResult.success(smileAgentService.getAgent(smileAgent));
    }

    @PostMapping("/create")
    @ApiOperation("创建/修改 票提")
    @ResponseBody
    public AjaxResult create(@RequestBody List<SmileAgent> smileAgents){
        if (smileAgentService.create(smileAgents)){
            return AjaxResult.success();
        }
        return AjaxResult.error();
    }


}
