package com.liquidnet.client.admin.web.controller.zhengzai.smile;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.smile.dto.*;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileUserService;
import com.liquidnet.service.smile.entity.SmileUser;
import com.liquidnet.service.smile.entity.dao.SmileUserCheckDao;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-14
 */
@Api(tags = "用户管理")
@Controller
@RequestMapping("/smile/user")
public class SmileUserController extends BaseController {

    @Autowired
    ISmileUserService iSmileUserService;

    @PostMapping("/list")
    @ApiOperation(value = "获取用户列表")
    @ResponseBody
    public AjaxResult userList(SmileUserParam smileUserParam) {
        PageInfo<SmileUserVo> smileUserVos = iSmileUserService.userList(smileUserParam);
        return AjaxResult.success(smileUserVos);
    }

    @PostMapping("/getUserById")
    @ApiOperation(value = "根据ID查询单个用户完整信息")
    @ResponseBody
    public AjaxResult getUserById(@RequestParam(name = "uid", required = true) String uid) {
        SmileUser smileUser = iSmileUserService.getUserById(uid);
        return AjaxResult.success(smileUser);
    }

    @PostMapping("/create")
    @ApiOperation(value = "保存用户")
    @ResponseBody
    public AjaxResult create(@RequestBody SmileUser smileUser) {
        if (iSmileUserService.create(smileUser)) {
            return AjaxResult.success();
        }
        return AjaxResult.warn("用户已添加");
    }

    @PostMapping("/getUserListByOrgId")
    @ApiOperation(value = "根据组织ID查询相人员信息")
    @ResponseBody
    public AjaxResult getUserListByOrgId(@RequestParam(name = "orgId", required = true) Long orgId, @RequestParam(name = "agentId", required = true) Long agentId) {
        List<SmileUserVoOrg> userListByOrgId = iSmileUserService.getUserListByOrgId(orgId, agentId);
        return AjaxResult.success(userListByOrgId);
    }

    @PostMapping("/updateUserStateByUid")
    @ApiOperation(value = "根据uid修改用户状态 0：正常，1：黑名单")
    @ResponseBody
    public AjaxResult updateUserStateById(@RequestParam(name = "uid", required = true) String uid, @RequestParam(name = "state", required = true) Integer state) {
        return iSmileUserService.updateUserStateById(uid, state);
    }

    @PostMapping("/check/list")
    @ApiOperation("获取审核列表")
    @ResponseBody
    public AjaxResult list(UserCheckParam userCheckParam) {
        PageInfo<SmileUserCheckDao> list = iSmileUserService.listUserCheck(userCheckParam);
        return AjaxResult.success(list);
    }

    @PostMapping("/check/updateById")
    @ApiOperation("修改审核  通过审核  1：总代，2：普代")
    @ResponseBody
    public AjaxResult updateById(@RequestBody SmileUserCheckVo smileUserCheckVo) {
        return iSmileUserService.updateUserCheckById(smileUserCheckVo);
    }

    @PostMapping("/redisDelUserByUid")
    @ApiOperation("根据uid删除redis中的用户")
    @ResponseBody
    public AjaxResult redisDelUserByUid(String uid) {
        return iSmileUserService.redisDelUserByUid(uid);
    }
}
