package com.liquidnet.client.admin.web.controller.zhengzai.smile;


import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileShowParam;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileShowService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author TT
 */
@Api(tags = "学校管理")
@RestController
@RequestMapping("/smile/show")
public class SmileShowController {

    @Autowired
    ISmileShowService smileShowService;

    @PostMapping("/list")
    @ApiOperation("演出列表")
    @ResponseBody
    public AjaxResult schoolList(SmileShowParam smileShowParam) {
        List<SmileShowParam> list = smileShowService.listShow(smileShowParam);
        return AjaxResult.success(list);
    }

}
