package com.liquidnet.service.platform.service.impl.smile;

import com.liquidnet.common.cache.redis.util.RedisSmileUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.goblin.constant.SmileRedisConst;
import com.liquidnet.service.goblin.dto.vo.SellDataDetailVO;
import com.liquidnet.service.goblin.dto.vo.SellDataOneVO;
import com.liquidnet.service.goblin.dto.vo.SellDataVO;
import com.liquidnet.service.kylin.mapper.KylinOrderTicketsMapper;
import com.liquidnet.service.platform.utils.ObjectUtil;
import com.liquidnet.service.smile.entity.SmileUser;
import com.liquidnet.service.smile.mapper.SmileUserMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * <p>
 * 订单 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-20
 */
@Service
@Slf4j
public class SellDataInfoImpl {
    @Autowired
    RedisSmileUtil redisSmileUtil;
    @Autowired
    SmileUserMapper smileUserMapper;
    @Autowired
    private KylinOrderTicketsMapper orderTicketsMapper;
    @Autowired
    private MongoTemplate mongoTemplate;

   public void setData(){
       //1、查到用户
       List<SmileUser>  list=smileUserMapper.selectUserList(null);
       //mongoTemplate.remove(Query.query(Criteria.where("deltag").is(0)), SellDataVO.class, SellDataVO.class.getSimpleName());
       for(SmileUser smileUser:list){
            //-- 看这个人有哪些演出维度的订单  (支付的、演出id，该用户的。)
           if(StringUtil.isNotBlank(smileUser.getUid())){
               List<Map> list1=orderTicketsMapper.getUserOrder(smileUser.getUid());
               for(Map a:list1){
                   String performanceId=a.get("yanchuId")==null?"":a.get("yanchuId").toString();
                   String yanChuName=a.get("title")==null?"":a.get("title").toString();
                   //获取 该人下 该演出id 的 所有订单
                   List<Map> list2=orderTicketsMapper.getUserSellOneDate(smileUser.getUid(),performanceId);
                   ArrayList<SellDataOneVO> listSellDataOneVo= ObjectUtil.getSellDataOneVOArrayList();
                   for(Map a1:list2){
                       SellDataOneVO sellDataOneVO=SellDataOneVO.getNew();
                       //票务类型
                       sellDataOneVO.setTicketName(a1.get("title")==null?"":a1.get("title").toString());
                       //数量
                       sellDataOneVO.setTicketNumber(a1.get("number")==null?0:Integer.parseInt(a1.get("number").toString()));
                       //总金额
                       sellDataOneVO.setSellPrice(new BigDecimal(a1.get("price")==null?"0":a1.get("price").toString()));
                       //票提
                       sellDataOneVO.setPiaoTi(new BigDecimal(a1.get("paioTi")==null?"":a1.get("paioTi").toString()));
                       //佣金
                       sellDataOneVO.setCommission(new BigDecimal(a1.get("commiss")==null?"0":a1.get("").toString()));
                       sellDataOneVO.setTicketId(a1.get("ticketId")==null?"":a1.get("ticketId").toString());
                       listSellDataOneVo.add(sellDataOneVO);
                       if(StringUtils.isNotBlank(sellDataOneVO.getTicketId())){
                           setDataDetial(smileUser.getUid(),a1.get("ticketId").toString());
                       }
                   }
                   Map allDate=orderTicketsMapper.getUserSellAllDate(smileUser.getUid(),performanceId);
                   SellDataVO sellDataVO=SellDataVO.getNew();
                   if(null!=allDate){
                       //活动名称   需要再查 目前没有
                       sellDataVO.setDeltag(0);
                       sellDataVO.setSellDataId(smileUser.getUid().concat(performanceId));
                       sellDataVO.setActiveName(yanChuName);
                       sellDataVO.setSellAmount(new BigDecimal(allDate.get("price")==null?"0":allDate.get("price").toString()));
                       sellDataVO.setSellNumber(new BigDecimal(allDate.get("number")==null?"0":allDate.get("number").toString()));
                       sellDataVO.setTotalCommission(new BigDecimal(allDate.get("commiss")==null?"0":allDate.get("commiss").toString()));
                       sellDataVO.setSellDataOneVO(listSellDataOneVo);
                       //redis 里面放入
                       redisSmileUtil.set(SmileRedisConst.SELL_DATA.concat(smileUser.getUid()).concat(performanceId),sellDataVO);
                       if(mongoTemplate.exists(Query.query(Criteria.where("sellDataId").is(sellDataVO.getSellDataId())), SellDataVO.class, SellDataVO.class.getSimpleName())){
                           mongoTemplate.remove(Query.query(Criteria.where("sellDataId").is(sellDataVO.getSellDataId())), SellDataVO.class, SellDataVO.class.getSimpleName());
                       }
                       //mongodb 里面放入
                       mongoTemplate.insert(sellDataVO,SellDataVO.class.getSimpleName());
                   }

               }
           }

       }
   }

    /**
     * 设置票维度 的订单详情
     */
   public void setDataDetial(String agentId,String ticketId){
       List<Map> list= orderTicketsMapper.getUserSellDetail(agentId,ticketId);
       SellDataDetailVO sellDataDetailVO=SellDataDetailVO.getNew();
       sellDataDetailVO.setDataId(agentId+ticketId);
       sellDataDetailVO.setList(list);
       // mongodb
       mongoTemplate.insert(sellDataDetailVO,SellDataDetailVO.class.getSimpleName());
   }
}
