package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 
 * </p>
 *
 * @author jobob
 * @since 2022-03-11
 */
@ApiModel(value = "SellDataOneVO", description = "销量数据")
@Data
public class SellDataVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "活动名字")
    private  String activeName;
    @ApiModelProperty(value = "id(用户+活动id)")
    private  String sellDataId;
    @ApiModelProperty(value = "销售具体情况")
    SellDataOneVO sellDataOneVO;
    @ApiModelProperty(value = "销售总金额")
    private BigDecimal sellAmount;
    @ApiModelProperty(value = "销售总数量")
    private BigDecimal sellNumber;
    @ApiModelProperty(value = "销售总佣金")
    private BigDecimal totalCommission;

    private static final SellDataVO obj = new SellDataVO();

    public static SellDataVO getNew() {
        try {
            return (SellDataVO) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SellDataVO();
        }
    }




}
