package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 商品NFT信息
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinGoodsSkuNft implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 单品id
     */
    private String skuId;

    /**
     * NFT路由
     */
    private String routeType;

    /**
     * 素材原始文件类型[1-图片|2-视频|3-模型]
     */
    private String materialType;

    /**
     * 素材原始文件URL
     */
    private String materialUrl;

    /**
     * NFT上传声明状态[0-待上传|1-已上传|2-上传失败|9-上传中]
     */
    private Integer upchain;

    /**
     * NFT预览图URL
     */
    private String displayUrl;

    /**
     * NFT素材访问URL
     */
    private String nftUrl;

    /**
     * NFT系列ID
     */
    private String seriesId;

    /**
     * NFT系列HASH
     */
    private String seriesHash;

    /**
     * NFT藏品HASH
     */
    private String nftHash;

    /**
     * NFT系列声明时间
     */
    private String declareAt;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;


}
