package com.liquidnet.service.sweet.handler;

import com.liquidnet.service.sweet.utils.WechatUsersRedisUtils;
import com.liquidnet.service.sweet.vo.SweetMaoDengVo;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
@Slf4j
public class MaodengImageHandler implements WxMpMessageHandler {

    @Autowired
    private WechatUsersRedisUtils redisUtils;

    @Override
    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> map, WxMpService wxMpService, WxSessionManager wxSessionManager) throws WxErrorException {
        String fromUser = wxMessage.getFromUser();//用户id
        String picUrl = wxMessage.getPicUrl();//图片url
        String maoContent = wxMessage.getContent();//获取文字消息
        SweetMaoDengVo sweetMaoDengVo = SweetMaoDengVo.getNew();
        sweetMaoDengVo.setUserId(fromUser);
        sweetMaoDengVo.setPicUrl(picUrl);
        Integer i = redisUtils.getSweetMaoDengOpen(fromUser);
        if (i == 1){
            //活动已开启  持久化
            redisUtils.setSweetMaoDengImage(sweetMaoDengVo);
        }else {
            //活动过期  不响应
            return null;
        }







        return null;
    }
}
