package com.liquidnet.service.sweet.handler;

import com.liquidnet.service.sweet.config.WechatMaConfigure;
import com.liquidnet.service.sweet.utils.WechatUsersRedisUtils;
import com.liquidnet.service.sweet.vo.SweetMaoDengVo;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.kefu.WxMpKefuMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutTextMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * <p>
 * 文本消息
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-25
 */
@Component
@Slf4j
public class TextMsgHandler implements WxMpMessageHandler {

    @Autowired
    private WechatUsersRedisUtils redisUtils;

    @Autowired
    WechatMaConfigure maConfigure;

    @Override
    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService wxMpService,
                                    WxSessionManager sessionManager) throws WxErrorException {
        String maoContent = wxMessage.getContent();//获取文字消息
        String fromUser = wxMessage.getFromUser();//用户id
        SweetMaoDengVo sweetMaoDengVo = SweetMaoDengVo.getNew();
        sweetMaoDengVo.setUserId(fromUser);
        sweetMaoDengVo.setTextMsg(maoContent);

        if(maoContent == "猫登天空"){
            redisUtils.setSweetMaoDengOpen(fromUser,10*60);
        }
        Integer i = redisUtils.getSweetMaoDengOpen(fromUser);
        if (i == 1){
            //活动已开启  持久化
            redisUtils.setSweetMaoDengText(sweetMaoDengVo);
        }else {
            //活动过期  不响应
            return null;
        }




//--------------------------------------------------------------------------------------------------------------------------
        boolean IsPosterClick = redisUtils.getStrawberryPosterClick(wxMessage.getFromUser());
        if (IsPosterClick) {
            String content = wxMessage.getContent();
            // 发送文本消息
            WxMpXmlOutTextMessage build = WxMpXmlOutMessage.TEXT().content("您已参与活动，输入的姓名为:".concat(content).concat(" 请点击下方小程序参加活动"))
                    .fromUser(wxMessage.getToUser()).toUser(wxMessage.getFromUser())
                    .build();
            // 发送活动小程序卡片
            WxMpKefuMessage message = WxMpKefuMessage.MINIPROGRAMPAGE()
                    .appId(maConfigure.getWxMaAppid(4))
                    .pagePath("/pages/index?nickname=".concat(content))
                    .thumbMediaId("ov08q51In7bXX6tXv7FewxFNN0G78n-pPRsbi3LZbPE")
                    .title("正在摩登")
                    .toUser(wxMessage.getFromUser())
                    .build();
            wxMpService.getKefuService().sendKefuMessage(message);
            return build;
        } else {
            // 正常消息不处理
            return null;
        }



    }
}
