package com.liquidnet.service.sweet.controller;

import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.utils.WechatUsersRedisUtils;
import com.liquidnet.service.sweet.vo.SweetMaoDengVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "猫登活动")
@RestController
@RequestMapping("/wechatMaoDeng")
@Slf4j
public class SweetWechatMaoDengController {

    @Autowired
    private WechatUsersRedisUtils redisUtils;

    @GetMapping("/backData")
    @ApiOperation("返回文字图片")
    public ResponseDto<SweetMaoDengVo> backDatas(String userId){
        userId="1234";

        SweetMaoDengVo sweetMaoDengVo = SweetMaoDengVo.getNew();
        String textMsg = redisUtils.getSweetMaoDengText(userId);
        String image = redisUtils.getSweetMaoDengImage(userId);
        sweetMaoDengVo.setPicUrl(image);
        sweetMaoDengVo.setTextMsg(textMsg);
        sweetMaoDengVo.setUserId(userId);
//        redisUtils.setSweetMaoDengText(sweetMaoDengVo,-1);
//        redisUtils.setSweetMaoDengImage(sweetMaoDengVo,-1);


        if (StringUtil.isEmpty(textMsg) && StringUtil.isEmpty(image)) {
            return ResponseDto.failure("90081", "获取信息失败");
        }

        return ResponseDto.success(sweetMaoDengVo);
    }

}
