package com.liquidnet.service.adam.service.impl.admin;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.AdamMemberParam;
import com.liquidnet.service.adam.dto.vo.AdamMemberVo;
import com.liquidnet.service.adam.entity.AdamMember;
import com.liquidnet.service.adam.entity.AdamMemberPrice;
import com.liquidnet.service.adam.mapper.AdamMemberMapper;
import com.liquidnet.service.adam.mapper.AdamMemberPriceMapper;
import com.liquidnet.service.adam.service.admin.IAdamMemberService;
import com.mongodb.BasicDBObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

@Slf4j
@Service
public class AdamMemberServiceImpl extends ServiceImpl<AdamMemberMapper, AdamMember> implements IAdamMemberService {

    @Autowired
    AdamMemberMapper adamMemberMapper;
    @Autowired
    AdamMemberPriceMapper adamMemberPriceMapper;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    MongoConverter mongoConverter;
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    RedisUtil redisUtil;

    @Override
    public List<AdamMember> list() {
        List<AdamMember> infoList = new ArrayList<>();
        List<Object> list = redisUtil.lGet(AdamRedisConst.INFO_MEMBERS, 0, -1);

        if (CollectionUtils.isEmpty(list)) {
            infoList = mongoTemplate.findAll(AdamMember.class);
        } else {
            for (Object o : list) {
                infoList.add((AdamMember) o);
            }
        }
        return infoList;
    }

    @Override
    public void add(AdamMemberParam info) {
        // mysql
        AdamMember adamMember = new AdamMember();
        BeanUtils.copyProperties(info, adamMember);
        adamMember.setMemberId(IDGenerator.nextSnowId().toString());
        adamMember.setStartNo(1000);
        adamMemberMapper.insert(adamMember);

        AdamMemberVo amv = new AdamMemberVo();
        BeanUtils.copyProperties(adamMember, amv);

        List<AdamMemberPrice> adamMemberPrices = adamMemberPriceMapper.memberPriceList(info.getMemberId());
        amv.setAdamMemberPrice((new AdamMemberVo()).setMemberPrice(adamMemberPrices));

        // 添加数据到 Mongo
        mongoTemplate.insert(Collections.singletonList(amv), AdamMemberVo.class.getSimpleName());
        // todo 放入MQ
//        rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
//                SqlMapping.get("adam_member.add", (new AdamMemberVo()).getMqList(adamMember).toArray()));
        // todo 同步redis
        redisUtil.hset(AdamRedisConst.INFO_MEMBERS_INFO.concat(info.getMemberId()), info.getMemberId(), amv);
    }

    @Override
    public void edit(AdamMember info) {
        BasicDBObject object = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(info)));

        mongoTemplate.getCollection(AdamMemberVo.class.getSimpleName())
                .updateOne(Query.query(Criteria.where("mId").is(info.getMid())).getQueryObject(), object);

        // todo 放入MQ
        redisUtil.hset(AdamRedisConst.INFO_MEMBERS_INFO.concat(info.getMid().toString()), info.getMid().toString(), info);
    }
}
