package com.liquidnet.service.kylin.service.impl.admin;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.kylin.dao.PerformanceAdminListDao;
import com.liquidnet.service.kylin.dao.PerformancePartnerListDao;
import com.liquidnet.service.kylin.dao.PerformanceTitleDao;
import com.liquidnet.service.kylin.dto.param.PerformanceAdminListParam;
import com.liquidnet.service.kylin.dto.param.PerformanceCreateParam;
import com.liquidnet.service.kylin.dto.vo.partner.PerformanceCreatePartnerVo;
import com.liquidnet.service.kylin.dto.vo.partner.TicketTimesTicketCreatePartnerVo;
import com.liquidnet.service.kylin.dto.vo.partner.TicketTimesCreatePartnerVo;
import com.liquidnet.service.kylin.dto.vo.partner.TicketCreatePartnerVo;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.service.admin.IKylinPerformancesAdminService;
import com.liquidnet.service.kylin.service.impl.partner.KylinTicketTimesPartnerServiceImpl;
import com.liquidnet.service.kylin.service.impl.partner.KylinTicketsPartnerServiceImpl;
import com.liquidnet.service.kylin.timerTask.PerformanceVoTask;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import org.bson.Document;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;

/**
 * <p>
 * 演出 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
@Service
public class KylinPerformancesAdminServiceImpl extends ServiceImpl<KylinPerformancesMapper, KylinPerformances> implements IKylinPerformancesAdminService {

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private MongoConverter mongoConverter;

    @Autowired
    private PerformanceVoTask performanceVoTask;

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private KylinPerformancesMapper performancesMapper;

    @Autowired
    private KylinPerformanceStatusMapper performanceStatusMapper;

    @Autowired
    private KylinPerformanceRelationsMapper performanceRelationsMapper;

    @Autowired
    private KylinTicketTimesPartnerServiceImpl ticketTimesPartnerService;

    @Autowired
    private KylinTicketsMapper ticketsMapper;

    @Autowired
    private KylinTicketStatusMapper ticketStatusMapper;

    @Autowired
    private KylinTicketRelationsMapper ticketRelationsMapper;

    @Autowired
    private KylinTicketTimesMapper ticketTimesMapper;

    @Autowired
    private KylinTicketTimeRelationMapper ticketTimeRelationMapper;

    @Autowired
    private KylinTicketsPartnerServiceImpl ticketsPartnerService;

    @Override
    public PerformanceCreatePartnerVo performanceDetails(String performancesId) {

        return mongoTemplate.findOne(
                Query.query(Criteria.where("performancesId").is(performancesId)),
                PerformanceCreatePartnerVo.class,
                PerformanceCreatePartnerVo.class.getSimpleName()
        );
    }

    @Override
    public boolean performanceAudit(String performancesId, int status, String rejectTxt) {
        try {
            LocalDateTime updatedAt = LocalDateTime.now();
            HashMap<String, Object> map = new HashMap<>();
            int auditStatus = 0;
            if (status == 3) {
                rejectTxt = "";
                auditStatus = 1;
                //修改演出
                map.put("rejectTxt", rejectTxt);
                map.put("status", status);
                map.put("auditStatus", auditStatus);
                map.put("updatedAt", updatedAt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                BasicDBObject objectPerformanceVo = new BasicDBObject("$set", mongoConverter.convertToMongoType(map));
                mongoTemplate.getCollection(PerformanceCreatePartnerVo.class.getSimpleName()).updateOne(
                        Query.query(Criteria.where("performancesId").is(performancesId)).getQueryObject(),
                        objectPerformanceVo
                );
            } else if (status == 4) {
                auditStatus = 2;
                map.put("rejectTxt", rejectTxt);
                map.put("auditStatus", auditStatus);
                map.put("status", status);
                map.put("updatedAt", updatedAt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                BasicDBObject object = new BasicDBObject("$set", mongoConverter.convertToMongoType(map));
                mongoTemplate.getCollection(PerformanceCreatePartnerVo.class.getSimpleName()).updateOne(
                        Query.query(Criteria.where("performancesId").is(performancesId)).getQueryObject(),
                        object
                );
            } else {
                return false;
            }

            //修改
            KylinPerformanceStatus performanceStatus = new KylinPerformanceStatus();
            performanceStatus.setStatus(status);
            performanceStatus.setAuditStatus(auditStatus);
            performanceStatus.setUpdatedAt(updatedAt);
            performanceStatusMapper.update(performanceStatus, new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performancesId));
            KylinPerformances performances = new KylinPerformances();
            performances.setUpdatedAt(updatedAt);
            performances.setRejectTxt(rejectTxt);
            performancesMapper.update(performances, new UpdateWrapper<KylinPerformances>().eq("performances_id", performancesId));

            List<TicketTimesCreatePartnerVo> ticketTimesCreatePartnerVos = ticketTimesPartnerService.getTimesMongoList(performancesId);
            for (TicketTimesCreatePartnerVo ticketTimeItem : ticketTimesCreatePartnerVos) {
                for (TicketCreatePartnerVo ticketItem : ticketsPartnerService.getTicketMongoList(ticketTimeItem.getTicketTimesId())) {
                    BasicDBObject objectTicketVo = new BasicDBObject("$set", mongoConverter.convertToMongoType(map));
                    mongoTemplate.getCollection(TicketCreatePartnerVo.class.getSimpleName()).updateOne(
                            Query.query(Criteria.where("ticketsId").is(ticketItem.getTicketsId())).getQueryObject(),
                            objectTicketVo
                    );
                    KylinTickets tickets = new KylinTickets();
                    tickets.setUpdatedAt(updatedAt);
                    ticketsMapper.update(tickets, new UpdateWrapper<KylinTickets>().eq("tickets_id", ticketItem.getTicketsId()));
                    KylinTicketStatus ticketStatus = new KylinTicketStatus();
                    ticketStatus.setUpdatedAt(updatedAt);
                    ticketStatus.setStatus(status);
                    ticketStatusMapper.update(ticketStatus, new UpdateWrapper<KylinTicketStatus>().eq("ticket_id", ticketItem.getTicketsId()));
                }
            }
            return true;
        } catch (Exception e) {
            System.out.println("ERROR DATA = " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public PageInfo<PerformanceAdminListDao> getList(PerformanceAdminListParam performanceAdminListParam) {
        PageInfo<PerformanceAdminListDao> pageInfoTmp = null;
        try {
            PageHelper.startPage(performanceAdminListParam.getPage(), performanceAdminListParam.getSize());
            List<PerformanceAdminListDao> voList = performancesMapper.misPerformanceList(BeanUtil.convertBeanToMap(performanceAdminListParam));
            pageInfoTmp = new PageInfo(voList);
        } catch (Exception e) {
            return null;
        }
        return pageInfoTmp;
    }

    @Override
    public List<PerformanceTitleDao> getListByRoadShowId(String roadShowId) {
        List<PerformanceTitleDao> voList = performancesMapper.misTitleByRoadShowIdList(roadShowId);
        return voList;
    }

    @Override
    public List<PerformanceTitleDao> getListByStatus(String status) {
        List<PerformanceTitleDao> voList = performancesMapper.misTitleByRoadShowIdList(status);
        return voList;
    }
}
