package com.liquidnet.commons.lang.util;

import java.io.Serializable;
import java.util.LinkedList;

public class SqlMessage implements Cloneable, Serializable {
    private static final long serialVersionUID = 2208924091512163151L;
    private LinkedList<String> sqls;
    private LinkedList<Object[]>[] args;

    public SqlMessage() {
    }

    public SqlMessage(String json) {
        SqlMessage sqlMessage = JsonUtils.fromJson(json, SqlMessage.class);
        this.sqls = sqlMessage.getSqls();
        this.args = sqlMessage.getArgs();
    }

    public LinkedList<String> getSqls() {
        return sqls;
    }

    public void setSqls(LinkedList<String> sqls) {
        this.sqls = sqls;
    }

    public LinkedList<Object[]>[] getArgs() {
        return args;
    }

    public void setArgs(LinkedList<Object[]>[] args) {
        this.args = args;
    }

    private final static SqlMessage instance = new SqlMessage();

    public static SqlMessage getInstance() {
        try {
            return (SqlMessage) instance.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new SqlMessage();
    }
}