package com.liquidnet.service.feign.bank.api.currencycloud;

import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcConversionDatesDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcConversionDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcConversionCreateParam;
import com.liquidnet.service.feign.bank.api.constant.FeignBankConstant;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Service
@FeignClient(name = FeignBankConstant.LIQUIDNET_SERVICE_BANK,
        path = FeignBankConstant.CONTEXT_PATH,
        fallback = FallbackFactory.Default.class,
        contextId = FeignBankConstant.CONTEXT_BANK_CC_CONVERSION)
public interface FeignBankCcConversionClient {

    @RequestMapping(value = "/bank-cc-conversion/create", method = RequestMethod.POST)
    ResponseDto<BankCcConversionDto> createConversion(@RequestBody BankCcConversionCreateParam param);

    @RequestMapping(value = "/bank-cc-conversion/get_conversion_dates", method = RequestMethod.GET)
    ResponseDto<BankCcConversionDatesDto> getConversionDates(@RequestParam String conversionPair, @RequestParam String startDate);

}
