package com.liquidnet.service.kylin.timerTask;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.TicketInventoryDto;
import com.liquidnet.service.kylin.dto.param.PerformanceCreateParam;
import com.liquidnet.service.kylin.dto.vo.PerformanceVo;
import com.liquidnet.service.kylin.dto.vo.TicketTimesVo;
import com.liquidnet.service.kylin.dto.vo.TicketVo;
import com.liquidnet.service.kylin.dto.vo.partner.PerformanceCreatePartnerVo;
import com.liquidnet.service.kylin.dto.vo.partner.TicketCreatePartnerVo;
import com.liquidnet.service.kylin.dto.vo.partner.TicketTimesCreatePartnerVo;
import com.liquidnet.service.kylin.dto.vo.partner.TicketTimesTicketCreatePartnerVo;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.service.impl.partner.KylinTicketTimesPartnerServiceImpl;
import com.liquidnet.service.kylin.service.impl.partner.KylinTicketsPartnerServiceImpl;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import org.bson.Document;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

@Component
public class PerformanceVoTask {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    private MongoConverter mongoConverter;

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private KylinPerformancesMapper performancesMapper;

    @Autowired
    private KylinPerformanceStatusMapper performanceStatusMapper;

    @Autowired
    private KylinPerformanceRelationsMapper performanceRelationsMapper;

    @Autowired
    private KylinTicketTimesPartnerServiceImpl ticketTimesPartnerService;

    @Autowired
    private KylinTicketsMapper ticketsMapper;

    @Autowired
    private KylinTicketStatusMapper ticketStatusMapper;

    @Autowired
    private KylinTicketRelationsMapper ticketRelationsMapper;

    @Autowired
    private KylinTicketTimesMapper ticketTimesMapper;

    @Autowired
    private KylinTicketTimeRelationMapper ticketTimeRelationMapper;

    @Autowired
    private KylinTicketsPartnerServiceImpl ticketsPartnerService;


    public void performanceVoStatus(String performanceSingleId) {

        LocalDateTime timeNow = LocalDateTime.now();
        List<String> performanceIdList = new ArrayList<>();

        if (performanceSingleId.isEmpty()) {
            List<PerformanceVo> PerformanceVoList = mongoTemplate.findAll(PerformanceVo.class);
            for (PerformanceVo performanceVoItem : PerformanceVoList) {
                performanceIdList.add(performanceVoItem.getPerformancesId());
            }
        } else {
            performanceIdList.add(performanceSingleId);
        }

        for (String performancesId : performanceIdList) {
            //场次
            List<TicketTimesVo> timesData = mongoTemplate.find(
                    Query.query(Criteria.where("performanceId").is(performancesId)),
                    TicketTimesVo.class, TicketTimesVo.class.getSimpleName()
            );
            //总循环次数
            int ticketCount = 0;
            //未开售次数
            int status9Count = 0;
            //售罄次数
            int status8Count = 0;
            //已结束次数
            int status10Count = 0;
            //演出数据
            HashMap<String, Object> mapPerformance = new HashMap<>();
            int appStatus = 6;
            for (TicketTimesVo ticketTimesVoItem : timesData) {
                //票
//                List<TicketVo> ticketVoList = ticketTimesVoItem.getTicketVoList();
                List<TicketVo> ticketVoList = mongoTemplate.find(
                        Query.query(Criteria.where("timeId").is(ticketTimesVoItem.getTimeId())),
                        TicketVo.class, TicketVo.class.getSimpleName()
                );
                ticketCount += ticketVoList.size();
                for (TicketVo ticketVoItem : ticketVoList) {
                    //时间判断
                    LocalDateTime timeStart = LocalDateTime.parse(ticketVoItem.getMemberTimeStart(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    LocalDateTime timeEnd = LocalDateTime.parse(ticketVoItem.getTimeEnd(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    int status = 0;
                    if (timeStart.isAfter(timeNow)) {
                        //未开始
                        status = 9;
                        status9Count += 1;
                    } else if (timeEnd.isBefore(timeNow)) {
                        //结束
                        status = 10;
                        status10Count += 1;
                    } else {
                        //库存判断
                        TicketInventoryDto ticketInventoryRedis = (TicketInventoryDto) redisUtil.hget(KylinRedisConst.PERFORMANCES_INVENTORY, ticketVoItem.getTicketsId());
                        if (ticketInventoryRedis.getSurplusGeneral() > 0) {
                            status = 6;
                        } else {
                            status = 8;
                            status8Count += 1;
                        }
                    }
                    //修改票状态
                    HashMap<String, Object> mapTicket = new HashMap<>();
                    mapTicket.put("status", status);
                    BasicDBObject objectTicket = new BasicDBObject("$set", mongoConverter.convertToMongoType(mapTicket));
                    mongoTemplate.getCollection(TicketVo.class.getSimpleName()).updateOne(
                            Query.query(Criteria.where("ticketsId").is(ticketVoItem.getTicketsId())).getQueryObject(),
                            objectTicket
                    );
//                    //修改场次 内 票数据
//                    mongoTemplate.getCollection(TicketTimesVo.class.getSimpleName()).updateOne(
//                            Query.query(Criteria.where("ticketVoList.ticketsId").is(ticketVoItem.getTicketsId())).getQueryObject(),
//                            objectTicket
//                    );
                    //演出状态
                    if (status == 6) {//单一票 可购买 则为可购买
                        appStatus = 6;
                    } else if (ticketCount == status8Count) {//全票售罄为售罄
                        appStatus = 8;
                    } else if (ticketCount == status9Count) {//全票未开始 为未开始
                        appStatus = 9;
                    } else if (ticketCount == status10Count) {//全票结束 为结束
                        appStatus = 10;
                    }
                }
            }
            //修改演出状态
            mapPerformance.put("appStatus", appStatus);
            BasicDBObject objectPerformance = new BasicDBObject("$set", mongoConverter.convertToMongoType(mapPerformance));
            mongoTemplate.getCollection(PerformanceVo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("performancesId").is(performancesId)).getQueryObject(),
                    objectPerformance
            );
        }
    }

    /**
     * 生成 PerformanceCreatePartnerVo(用于审核第一次提交数据)
     * @param performancesId
     * @return
     */
    public PerformanceCreatePartnerVo createPerformanceCreateParam(String performancesId){
        PerformanceCreateParam performanceData = mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performancesId)), PerformanceCreateParam.class, PerformanceCreateParam.class.getSimpleName());
        List<TicketTimesCreatePartnerVo> ticketTimesCreatePartnerVos = ticketTimesPartnerService.getTimesMongoList(performancesId);
        List<TicketTimesTicketCreatePartnerVo> ticketTimesTicketCreatePartnerVoList = new ArrayList<TicketTimesTicketCreatePartnerVo>();

        ArrayList<BigDecimal> floatList = new ArrayList<>();
        ArrayList<String> StringList = new ArrayList<>();

        for (TicketTimesCreatePartnerVo ticketTimes : ticketTimesCreatePartnerVos) {
            TicketTimesTicketCreatePartnerVo ticketTimesTicketCreatePartnerVo = new TicketTimesTicketCreatePartnerVo();
            BeanUtils.copyProperties(ticketTimes, ticketTimesTicketCreatePartnerVo);
            List<TicketCreatePartnerVo> ticketCreatePartnerVos = ticketsPartnerService.getTicketMongoList(ticketTimes.getTicketTimesId());
            ticketTimesTicketCreatePartnerVo.setTicket(ticketCreatePartnerVos);
            ticketTimesTicketCreatePartnerVoList.add(ticketTimesTicketCreatePartnerVo);
            for (TicketCreatePartnerVo ticketCreatePartnerVoItem : ticketCreatePartnerVos) {
                floatList.add(ticketCreatePartnerVoItem.getPrice());
                StringList.add(ticketCreatePartnerVoItem.getTimeEnd());
            }
        }
        PerformanceCreatePartnerVo performanceCreatePartnerVo = new PerformanceCreatePartnerVo();
        BeanUtils.copyProperties(performanceData, performanceCreatePartnerVo);

        floatList.sort(Comparator.reverseOrder());
        StringList.sort(Comparator.naturalOrder());

        performanceCreatePartnerVo.setPrice(floatList.get(0) + "起");
        performanceCreatePartnerVo.setStopSellTime(StringList.get(0));
        performanceCreatePartnerVo.setTicketTimes(ticketTimesTicketCreatePartnerVoList);
        performanceCreatePartnerVo.setStatus(1);
        performanceCreatePartnerVo.setStatusSell(1);
        performanceCreatePartnerVo.setRejectTxt("");

        performanceCreatePartnerVo.setIsShow(1);
        performanceCreatePartnerVo.setIsDistribution(0);
        performanceCreatePartnerVo.setSyncAgent(0);
        performanceCreatePartnerVo.setAuditStatus(0);

        boolean exists = mongoTemplate.exists(Query.query(Criteria.where("performancesId").is(performancesId)), PerformanceCreatePartnerVo.class, PerformanceCreatePartnerVo.class.getSimpleName());

        if (!exists) {
            PerformanceCreatePartnerVo data = mongoTemplate.insert(
                    performanceCreatePartnerVo, PerformanceCreatePartnerVo.class.getSimpleName()
            );
        }

        return performanceCreatePartnerVo;
    }

    public void createPerformanceMySql(String performancesId,HashMap<String, Object> map,PerformanceCreatePartnerVo performanceCreatePartnerVo,LocalDateTime updatedAt){
        try {
            //创建演出
            KylinPerformances performances = new KylinPerformances();
            BeanUtils.copyProperties(performanceCreatePartnerVo, performances);
            KylinPerformanceStatus performanceStatus = new KylinPerformanceStatus();
            BeanUtils.copyProperties(performanceCreatePartnerVo, performanceStatus);
            KylinPerformanceRelations performanceRelations = new KylinPerformanceRelations();
            BeanUtils.copyProperties(performanceCreatePartnerVo, performanceRelations);

            performances.setCreatedAt(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(performanceCreatePartnerVo.getCreatedAt())));
            performances.setTimeStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(performanceCreatePartnerVo.getTimeStart())));
            performances.setTimeEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(performanceCreatePartnerVo.getTimeEnd())));
            performances.setUpdatedAt(updatedAt);

            performanceStatus.setPerformanceId(performances.getPerformancesId());
            performanceStatus.setPerformanceStatusId(IDGenerator.nextSnowId().toString());
            performanceStatus.setCreatedAt(performances.getCreatedAt());
            performanceStatus.setAuditStatus(0);
            performanceStatus.setUpdatedAt(updatedAt);

            performanceRelations.setPerformanceId(performances.getPerformancesId());
            performanceRelations.setPerformanceRelationsId(IDGenerator.nextSnowId().toString());
            performanceRelations.setCreatedAt(performances.getCreatedAt());
            performanceRelations.setUpdatedAt(updatedAt);

            performancesMapper.insert(performances);
            performanceStatusMapper.insert(performanceStatus);
            performanceRelationsMapper.insert(performanceRelations);


            //场次数据
            List<TicketTimesCreatePartnerVo> ticketTimesCreatePartnerVos = ticketTimesPartnerService.getTimesMongoList(performancesId);
            for (TicketTimesCreatePartnerVo ticketTimeItem : ticketTimesCreatePartnerVos) {
                //创建场次
                KylinTicketTimes ticketTimes = new KylinTicketTimes();
                BeanUtils.copyProperties(ticketTimeItem, ticketTimes);
                KylinTicketTimeRelation ticketTimeRelation = new KylinTicketTimeRelation();
                BeanUtils.copyProperties(ticketTimeItem, ticketTimeRelation);

                ticketTimes.setUseStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseStart())));
                ticketTimes.setUseEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseEnd())));
                ticketTimes.setCreatedAt(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getCreatedAt())));
                ticketTimes.setUpdatedAt(updatedAt);

                ticketTimeRelation.setPerformanceId(performancesId);
                ticketTimeRelation.setTicketTimeRelationId(IDGenerator.nextSnowId().toString());
                ticketTimeRelation.setTimesId(ticketTimes.getTicketTimesId());
                ticketTimeRelation.setCreatedAt(ticketTimes.getCreatedAt());
                ticketTimeRelation.setUpdatedAt(updatedAt);

                ticketTimesMapper.insert(ticketTimes);
                ticketTimeRelationMapper.insert(ticketTimeRelation);

                //修改票
                for (TicketCreatePartnerVo ticketItem : ticketsPartnerService.getTicketMongoList(ticketTimeItem.getTicketTimesId())) {
                    BasicDBObject objectTicketVo = new BasicDBObject("$set", mongoConverter.convertToMongoType(map));
                    Document docTicket = mongoTemplate.getCollection(TicketCreatePartnerVo.class.getSimpleName()).findOneAndUpdate(
                            Query.query(Criteria.where("ticketsId").is(ticketItem.getTicketsId())).getQueryObject(),
                            objectTicketVo,
                            new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
                    );
                    TicketCreatePartnerVo ticketCreatePartnerVo = JsonUtils.fromJson(docTicket.toJson(), TicketCreatePartnerVo.class);

                    //创建演出
                    KylinTickets tickets = new KylinTickets();
                    BeanUtils.copyProperties(ticketCreatePartnerVo, tickets);
                    KylinTicketStatus ticketStatus = new KylinTicketStatus();
                    BeanUtils.copyProperties(ticketCreatePartnerVo, ticketStatus);
                    KylinTicketRelations ticketRelations = new KylinTicketRelations();
                    BeanUtils.copyProperties(ticketCreatePartnerVo, ticketRelations);

                    tickets.setPriceExpress(new BigDecimal("0.00"));
                    tickets.setPriceDiscountMember(new BigDecimal("0.00"));
                    tickets.setPriceDiscount(new BigDecimal("0.00"));
                    tickets.setTimeStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeStart())));
                    tickets.setTimeEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeEnd())));
                    tickets.setTimeEndExpress(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeEndExpress())));
                    tickets.setUseStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseStart())));
                    tickets.setUseEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseEnd())));
                    tickets.setSaleRemindMinute(60);
                    tickets.setCreatedAt(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getCreatedAt())));
                    tickets.setUpdatedAt(updatedAt);

                    ticketStatus.setTicketStatusId(IDGenerator.nextSnowId().toString());
                    ticketStatus.setTicketId(tickets.getTicketsId());
                    ticketStatus.setCounts(1);
                    ticketStatus.setIsMember(1);
                    ticketStatus.setStatusExchange(7);
                    ticketStatus.setQrCodeShowTime(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getQrCodeShowTime())));

                    ticketRelations.setCreatedAt(tickets.getCreatedAt());
                    ticketRelations.setUpdatedAt(updatedAt);

                    ticketRelations.setTicketRelationsId(IDGenerator.nextSnowId().toString());
                    ticketRelations.setTicketId(tickets.getTicketsId());
                    ticketRelations.setCreatedAt(tickets.getCreatedAt());
                    ticketRelations.setUpdatedAt(updatedAt);

                    ticketsMapper.insert(tickets);
                    ticketStatusMapper.insert(ticketStatus);
                    ticketRelationsMapper.insert(ticketRelations);
                }
            }
        }catch (Exception e){

        }
    }
}
