package com.liquidnet.service.constant;

import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.liquidnet.commons.lang.util.JsonUtils;

public enum SendTargetEnum {
	/**
	 * 1、订单结清未复借
	 * 2、授信成功用户
	 * 3、授信成功未借款用户
	 * 4、放款成功未提现用户
	 * 5、借款成功用户
	 * 6、注册成功用户
	 */
	SETTLENOLOAN("1000","订单结清未复借 "),
	CREDITSUCCESS("2000","授信成功用户 "),
	CREDITSUCCESSNOLOAN("3000","授信成功未借款用户 "),
	LOANSUCCESSNOWITHDRAWALS("4000","放款成功未提现用户 "),
	LOANSUCCESS("5000","借款成功用户 "),
	REGISTERUCCESS("6000","注册成功用户 "),
	REGISTERSUCCESSNOTCREDIT("7000","注册成功未信审 "),
	CREDITINGANDCREDITSUCCESS("8000","注册成功信审中、信审成功 "),
	;
	private String code;
	private String msg;

	private SendTargetEnum(String code,String msg){
		this.code=code;
		this.msg=msg;
	}

	public String getCode() {
		return code;
	}

	public String getMsg() {
		return msg;
	}

	public static String getMsg(String code){
		SendTargetEnum[] enums=SendTargetEnum.values();
		if(StringUtils.isEmpty(code)){
			return null;
		}
		for(SendTargetEnum e:enums){
			if(e.code.equals(code)){
				return e.msg;
			}
		}
		return null;
	}
	public static SendTargetEnum getEnum(String code){
		SendTargetEnum[] enums=SendTargetEnum.values();
		if(StringUtils.isEmpty(code)){
			return null;
		}
		for(SendTargetEnum e:enums){
			if(e.code.equals(code)){
				return e;
			}
		}
		return null;
	}

	public static String triggerType(){
		SendTargetEnum[] enums=SendTargetEnum.values();
		Map<String,String> map=new LinkedHashMap<String,String>();
		for(SendTargetEnum e:enums){
			map.put(e.code, e.msg);
		}
		return JsonUtils.toJson(map);

	}
	public static void main(String[] args) {
		SendTargetEnum[] enums=SendTargetEnum.values();
		Map<String,String> map=new LinkedHashMap<String,String>();
		for(SendTargetEnum e:enums){
			map.put(e.code, e.msg);
		}
		System.out.println(JsonUtils.toJson(map));
	}
}
