package com.liquidnet.client.admin.zhengzai.smile.dto;

import com.liquidnet.client.admin.common.annotation.Excel;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;

/**
 * @author jiangxiulong
 */
@Data
public class SmileShowExportVo implements Serializable, Cloneable {
    @Excel(name = "演出id", cellType = Excel.ColumnType.STRING)
    private String performancesId;
    @Excel(name = "演出名", cellType = Excel.ColumnType.STRING)
    private String title;
    @Excel(name = "城市", cellType = Excel.ColumnType.STRING)
    private String cityName;
    @Excel(name = "演出开始时间", cellType = Excel.ColumnType.STRING)
    private String timeStart;
    @Excel(name = "演出结束时间", cellType = Excel.ColumnType.STRING)
    private String timeEnd;
    @Excel(name = "总销售数量", cellType = Excel.ColumnType.NUMERIC)
    private BigDecimal open;
    @Excel(name = "总销售金额", cellType = Excel.ColumnType.NUMERIC)
    private BigDecimal totalSalePrice;
    @Excel(name = "总售出代理", cellType = Excel.ColumnType.NUMERIC)
    private Integer totalOutAgent;
    @Excel(name = "演出状态", cellType = Excel.ColumnType.STRING)
    private String statusName;
    @Excel(name = "打款状态", cellType = Excel.ColumnType.STRING)
    private String status;


    private static final SmileShowExportVo obj = new SmileShowExportVo();

    public static SmileShowExportVo getNew() {
        try {
            return (SmileShowExportVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new SmileShowExportVo();
    }

    public SmileShowExportVo copyExportVo(ShowVo source) {
        this.setPerformancesId(source.getPerformancesId());
        this.setTitle(source.getTitle());
        this.setCityName(source.getCityName());
        this.setOpen(source.getOpen());
        this.setTotalSalePrice(source.getTotalSalePrice());
        this.setTotalOutAgent(source.getTotalOutAgent());
        this.setTimeEnd(source.getTimeEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        this.setTimeStart(source.getTimeStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        this.setStatusName(source.getStatusName());
        if (source.getStatus() == "1") {
            this.setStatus("已打款");
        } else {
            this.setStatus("未打款");
        }
        return this;
    }

}
