package com.liquidnet.service.chime.utils;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.chime.constant.ChimeConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: RedisDataUtil
 * @Package com.liquidnet.service.chime.utils
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/22 11:08
 */
@Slf4j
@Component
public class RedisDataUtil {
    @Autowired
    private RedisUtil redisUtil;

    /**
     * 根据演出id判断是否开放社交
     * @param performanceId
     * @return
     */
    public boolean isPassedByPerformanceId(String performanceId){
        boolean isPass = false;
        //允许的演出
        Object allowPerIds = redisUtil.getRedisTemplateByDb(250).opsForValue().get(ChimeConstant.REDIS_PERFORMANCE_IDS_ALLOW);
        log.info("isPassedByPerformanceId allowPerIds:{}",allowPerIds);
        if(StringUtil.isNotNull(allowPerIds)){
            String perIds = (String)allowPerIds;
            List<String> perIdsList = Arrays.asList(perIds.split(","));
            if(perIdsList.contains(performanceId)){
                isPass =  true;
            }
            //如果为-1 则全部允许
            if(perIdsList.contains("-1")){
                isPass =  true;
            }
        }
        //演出黑名单
        Object notAllowPerIds = redisUtil.getRedisTemplateByDb(250).opsForValue().get(ChimeConstant.REDIS_PERFORMANCE_IDS_NOT_ALLOW);
        log.info("isPassedByPerformanceId notAllowPerIds:{}",notAllowPerIds);
        if(StringUtil.isNotNull(notAllowPerIds)){
            String notPerIds = (String)notAllowPerIds;
            List<String> notPerIdsList = Arrays.asList(notPerIds.split(","));
            if(notPerIdsList.contains(performanceId)){
                isPass = false;
            }
        }
        return isPass;
    }

    /**
     * 根据演出地点判断是否开放社交
     * @param cityName
     * @return
     */
    public boolean isPassedByCityName(String cityName){
        boolean isPass = false;
        //允许的演出
        Object allowCityNameIds = redisUtil.getRedisTemplateByDb(250).opsForValue().get(ChimeConstant.REDIS_CITY_NAME_ALLOW);
        log.info("isPassedByCityName allowCityNameIds:{}",allowCityNameIds);
        if(StringUtil.isNotNull(allowCityNameIds)){
            String perIds = (String)allowCityNameIds;
            List<String> perIdsList = Arrays.asList(perIds.split(","));
            if(perIdsList.contains(cityName)){
                isPass = true;
            }
            //如果为-1 则全部允许
            if(perIdsList.contains("-1")){
                isPass =  true;
            }
        }
        //不允许的演出
        Object notAllowCityNameIds = redisUtil.getRedisTemplateByDb(250).opsForValue().get(ChimeConstant.REDIS_CITY_NAME_NOT_ALLOW);
        log.info("isPassedByCityName notAllowCityNameIds:{}",notAllowCityNameIds);
        if(StringUtil.isNotNull(notAllowCityNameIds)){
            String notPerIds = (String)notAllowCityNameIds;
            List<String> notPerIdsList = Arrays.asList(notPerIds.split(","));
            if(notPerIdsList.contains(cityName)){
                isPass = false;
            }
        }
        return isPass;
    }
}
