package com.liquidnet.service.adam.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 实名信息
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamRealName implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    private String realNameId;

    private String uid;

    /**
     * 1-大陆身份证,2-港澳通行证,3-台胞证,4-护照,5-军官证
     */
    private String type;

    /**
     * 真实姓名
     */
    private String name;

    /**
     * 证件号码
     */
    private String idCard;

    /**
     * 0-INIT,1-NORMAL,2-INVALID
     */
    private Integer state;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;


}
