package com.liquidnet.client.admin.zhengzai.smile.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.utils.StringUtils;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileAgentDao;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileAgentService;
import com.liquidnet.client.admin.zhengzai.smile.utils.SmileRedisUtils;
import com.liquidnet.service.goblin.constant.SmileRedisConst;
import com.liquidnet.service.goblin.dto.vo.SmileAgentVo;
import com.liquidnet.service.kylin.entity.KylinTickets;
import com.liquidnet.service.kylin.mapper.KylinPerformancesMapper;
import com.liquidnet.service.kylin.mapper.KylinTicketsMapper;
import com.liquidnet.service.smile.entity.SmileAgent;
import com.liquidnet.service.smile.mapper.SmileAgentMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-16
 */
@Service
@Slf4j
public class SmileAgentServiceImpl extends ServiceImpl<SmileAgentMapper, SmileAgent> implements ISmileAgentService {

    @Autowired
    SmileAgentMapper smileAgentMapper;

    @Autowired
    SmileRedisUtils smileRedisUtils;

    @Autowired
    KylinTicketsMapper kylinTicketsMapper;

    @Autowired
    KylinPerformancesMapper kylinPerformancesMapper;

    @Override
    public SmileAgent listAgentByShowIdAndTicketId(String performanceId, String ticketId) {
        if (StringUtils.isNotEmpty(performanceId) && StringUtils.isNotEmpty(ticketId)) {
            LambdaQueryWrapper<SmileAgent> queryWrapper = Wrappers.lambdaQuery(SmileAgent.class);
            queryWrapper.eq(SmileAgent::getPerformanceId, performanceId);
            queryWrapper.eq(SmileAgent::getTicketId, ticketId);
            queryWrapper.eq(SmileAgent::getDelTag,0);
            smileAgentMapper.selectOne(queryWrapper);
            return null;
        }
        return null;
    }

    @Override
    public boolean create(List<SmileAgent> smileAgents) {
        boolean result = true;
        if (StringUtils.isNotEmpty(smileAgents)) {
            for (SmileAgent agent : smileAgents) {
                result = !StringUtils.isEmpty(agent.getPerformanceId()) && !StringUtils.isEmpty(agent.getTicketId());
            }
            if (result) {
                try {
                    smileAgents.forEach(smileAgent -> {
                        //是否是修改票提
                        smileAgentMapper.updateAgentById(smileAgent.getId(),smileAgent.getTotalCarry(),smileAgent.getOrdCarry());
                        SmileAgentVo smileAgentVo = new SmileAgentVo();
                        BeanUtils.copyProperties(smileAgent, smileAgentVo);
                        smileRedisUtils.set(SmileRedisConst.SMILE_AGENT.concat(smileAgent.getPerformanceId()).concat(":").concat(smileAgent.getTicketId()), smileAgentVo);
                        log.debug("create create Agent id：{},PerformanceId:{},TicketId:{}",
                                smileAgent.getId(),
                                smileAgent.getPerformanceId(),
                                smileAgent.getTicketId());

                      /*  LambdaQueryWrapper<SmileAgent> queryWrapper = Wrappers.lambdaQuery(SmileAgent.class);
                        queryWrapper.eq(SmileAgent::getPerformanceId, smileAgent.getPerformanceId());
                        queryWrapper.eq(SmileAgent::getTicketId, smileAgent.getTicketId());
                        queryWrapper.eq(SmileAgent::getDelTag,0);
                        if (smileAgentMapper.selectOne(queryWrapper) != null) {
                            //修改
                            smileAgentMapper.update(smileAgent, queryWrapper);
                            SmileAgentVo smileAgentVo = new SmileAgentVo();
                            BeanUtils.copyProperties(smileAgent, smileAgentVo);
                            smileRedisUtils.set(SmileRedisConst.SMILE_AGENT.concat(smileAgent.getPerformanceId()).concat(":").concat(smileAgent.getTicketId()), smileAgentVo);
                            log.debug("create update Agent id：{},PerformanceId:{},TicketId:{}",
                                    smileAgent.getId(),
                                    smileAgent.getPerformanceId(),
                                    smileAgent.getTicketId());
                        } else {
                            //新增
                            smileAgentMapper.insert(smileAgent);
                            SmileAgentVo smileAgentVo = new SmileAgentVo();
                            BeanUtils.copyProperties(smileAgent, smileAgentVo);
                            smileRedisUtils.set(SmileRedisConst.SMILE_AGENT.concat(smileAgent.getPerformanceId()).concat(":").concat(smileAgent.getTicketId()), smileAgentVo);
                            log.debug("create create Agent id：{},PerformanceId:{},TicketId:{}",
                                    smileAgent.getId(),
                                    smileAgent.getPerformanceId(),
                                    smileAgent.getTicketId());
                        }*/
                    });
                    return true;
                } catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public AjaxResult getAgent(String performancesId) {
        if (StringUtils.isNotEmpty(performancesId)){
            LambdaQueryWrapper<SmileAgent> queryWrapper = Wrappers.lambdaQuery(SmileAgent.class);
            queryWrapper.eq(SmileAgent::getPerformanceId, performancesId);
            queryWrapper.eq(SmileAgent::getDelTag,0);
            List<SmileAgent> agents = smileAgentMapper.selectList(queryWrapper);
            List<SmileAgentDao> smileAgentDaoList = new ArrayList<>(agents.size());
            agents.forEach(s -> {
                SmileAgentDao smileAgentDao = new SmileAgentDao();
                BeanUtils.copyProperties(s, smileAgentDao);
                //根据票提ID查询票种名称
                LambdaQueryWrapper<KylinTickets> kylinTicketsQueryWrapper = Wrappers.lambdaQuery(KylinTickets.class);
                kylinTicketsQueryWrapper.eq(KylinTickets::getTicketsId,s.getTicketId());
                smileAgentDao.setTicketName(kylinTicketsMapper.selectOne(kylinTicketsQueryWrapper).getTitle());
                smileAgentDaoList.add(smileAgentDao);
            });
            return AjaxResult.success(smileAgentDaoList);
        }

        /*//查询该演出id 开启代理的票
        List<KylinPerformancesDao> kylinPerformancesDaoList = kylinPerformancesMapper.selectTicketIdByPerId(performancesId);

        if (StringUtils.isNotEmpty(kylinPerformancesDaoList)) {
            List<ShowAgentDao> smileAgentDaoList = new ArrayList<>(kylinPerformancesDaoList.size());
            for (KylinPerformancesDao kylinPerformancesDao : kylinPerformancesDaoList) {
                //根据票id查询票名
                LambdaQueryWrapper<KylinTickets> queryWrapper = Wrappers.lambdaQuery(KylinTickets.class);
                queryWrapper.eq(KylinTickets::getTicketsId, kylinPerformancesDao.getTicketId());
                ShowAgentDao showAgentDao = kylinTicketsMapper.selectOneByPerIdAndTicketId(kylinPerformancesDao.getTicketId());
                showAgentDao.setTicketId(kylinPerformancesDao.getTicketId());
                showAgentDao.setPerformancesId(performancesId);
                smileAgentDaoList.add(showAgentDao);
            }
            return AjaxResult.success(smileAgentDaoList);
        }*/
        return AjaxResult.warn("演出未开启代理");
    }
}
