package com.liquidnet.service.merchant.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.merchant.entity.MerchantFieldApplies;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

@ApiModel(value = "MerchantFieldAppliesVo", description = "申请的场地")
@Data
public class MerchantFieldAppliesVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -3241866244946476511L;

    @ApiModelProperty(position = 10, value = "场地申请ID")
    private String fieldApplyId;
    @ApiModelProperty(position = 11, value = "场地申请状态 0-待审核 1-通过 2-驳回")
    private Integer applyStatus;
    @ApiModelProperty(position = 12, value = "场地申请类型 claim-认领、create-创建")
    private String applyType;
    @ApiModelProperty(position = 13, value = "驳回原因")
    private String reject;
    @ApiModelProperty(position = 14, value = "用户ID")
    private String uid;

    @ApiModelProperty(position = 15, value = "场地ID，认领时或通过后存在")
    private String fieldId;
    @ApiModelProperty(position = 16, value = "场地，认领时或通过后存在")
    private MerchantFieldsVo fieldVo;

    @ApiModelProperty(position = 17, value = "场地名称[30]")
    private String name;
    @ApiModelProperty(position = 18, value = "logo图")
    private String logo;
    @ApiModelProperty(position = 19, value = "背景图")
    private String background;
    @ApiModelProperty(position = 20, value = "介绍[1000]")
    private String description;
    @ApiModelProperty(position = 21, value = "建立日期[YYYY-MM-DD]")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_SMALL_STR)
    private LocalDate builtDate;

    @ApiModelProperty(position = 22, value = "省id")
    private String provinceId;
    @ApiModelProperty(position = 23, value = "省名称")
    private String provinceName;
    @ApiModelProperty(position = 24, value = "城市id")
    private String cityId;
    @ApiModelProperty(position = 25, value = "城市名称")
    private String cityName;
    @ApiModelProperty(position = 26, value = "县id")
    private String districtId;
    @ApiModelProperty(position = 27, value = "县名称")
    private String districtName;
    @ApiModelProperty(position = 28, value = "详细地址[100]")
    private String address;
    @ApiModelProperty(position = 29, value = "经度")
    private String longitude;
    @ApiModelProperty(position = 30, value = "纬度")
    private String latitude;

    @ApiModelProperty(position = 31, value = "联系人姓名")
    private String contactName;
    @ApiModelProperty(position = 32, value = "联系人邮箱")
    private String contactEmail;

    @ApiModelProperty(position = 33, value = "企业名称")
    private String companyName;
    @ApiModelProperty(position = 34, value = "营业执照编号")
    private String licenseCode;
    @ApiModelProperty(position = 35, value = "营业执照图片")
    private String licenseImg;

    @ApiModelProperty(position = 36, value = "法人姓名")
    private String legalName;
    @ApiModelProperty(position = 37, value = "法人身份证号码")
    private String legalIdentity;
    @ApiModelProperty(position = 38, value = "法人身份证正面照")
    private String legalIdentityObverse;
    @ApiModelProperty(position = 39, value = "法人身份证反面照")
    private String legalIdentityReverse;

    @ApiModelProperty(position = 40, value = "审核人ID")
    private String auditUid;
    @ApiModelProperty(position = 41, value = "审核人姓名")
    private String auditName;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime auditedAt;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime deletedAt;


    private static final MerchantFieldAppliesVo obj = new MerchantFieldAppliesVo();

    public static MerchantFieldAppliesVo getNew() {
        try {
            return (MerchantFieldAppliesVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new MerchantFieldAppliesVo();
    }

    public MerchantFieldAppliesVo copy(MerchantFieldApplies source) {
        if (null == source) return this;

        this.setFieldApplyId(source.getFieldApplyId());
        this.setApplyStatus(source.getApplyStatus());
        this.setApplyType(source.getApplyType());
        this.setReject(source.getReject());
        this.setUid(source.getUid());

        this.setFieldId(source.getFieldId());

        this.setName(source.getName());
        this.setLogo(source.getLogo());
        this.setBackground(source.getBackground());
        this.setDescription(source.getDescription());
        this.setBuiltDate(source.getBuiltDate());

        this.setProvinceId(source.getProvinceId());
        this.setProvinceName(source.getProvinceName());
        this.setCityId(source.getCityId());
        this.setCityName(source.getCityName());
        this.setDistrictId(source.getDistrictId());
        this.setDistrictName(source.getDistrictName());
        this.setAddress(source.getAddress());
        this.setLongitude(source.getLongitude());
        this.setLatitude(source.getLatitude());

        this.setContactName(source.getContactName());
        this.setContactEmail(source.getContactEmail());

        this.setCompanyName(source.getCompanyName());
        this.setLicenseCode(source.getLicenseCode());
        this.setLicenseImg(source.getLicenseImg());

        this.setLegalName(source.getLegalName());
        this.setLegalIdentity(source.getLegalIdentity());
        this.setLegalIdentityObverse(source.getLegalIdentityObverse());
        this.setLegalIdentityReverse(source.getLegalIdentityReverse());

        this.setAuditUid(source.getAuditUid());
        this.setAuditName(source.getAuditName());
        this.setAuditedAt(source.getAuditedAt());

        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());
        this.setDeletedAt(source.getDeletedAt());

        return this;
    }
}
