package com.liquidnet.service.kylin.controller;

import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dao.KylinFreightChargeDao;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "前端-获取快递价格")
@RestController
@RequestMapping("getShunFengPrice")
@Slf4j
public class KylinGetShunFengPriceController {

    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;
    @Autowired
    private RedisUtil redisUtil;

    @GetMapping("getPrice")
    @ApiOperation("运费查询")
    public String getFreightCharge(String adcode,String expressType){

        Object obj =redisUtil.get(KylinRedisConst.RETURN_ADDRESS_CODE+adcode+KylinRedisConst.EXPRESS_TYPE+expressType);
        if (obj != null){
            KylinFreightChargeDao k= (KylinFreightChargeDao)obj;
            return k.getPrice();
        }else {
            return null;
        }
    }


}
