package com.liquidnet.service.adam.config;

import com.liquidnet.common.swagger.config.Swagger2Config;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import io.swagger.annotations.Api;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: TODO
 * @class: Swagger2Config
 * @Package com.liquidnet.stellar.configuration
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/9/10 13:55
 */
@Configuration
class AdamSwagger2Config extends Swagger2Config {

    @Override
    public Docket createRestApi() {

        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(this.apiInfo())
                .forCodeGeneration(true).select()
                .apis(RequestHandlerSelectors.withClassAnnotation(Api.class))
                .paths(PathSelectors.any())
                .build();

//        return new Docket(DocumentationType.SWAGGER_2)
//                .apiInfo(this.apiInfo())
//                .groupName(AdamSwaggerApiVersionConstant.WEB_1_1)
//                .select()
//                .apis(input -> {
//                    SwaggerApiVersion apiVersion = input.getHandlerMethod().getMethodAnnotation(SwaggerApiVersion.class);
//                    return apiVersion != null && Arrays.asList(apiVersion.group()).contains(AdamSwaggerApiVersionConstant.WEB_1_1);
//                })
//                .paths(PathSelectors.any())
//                .build();
    }

    @Bean
    public Docket api_admin() {
        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(this.apiInfo())
                .groupName(AdamSwaggerApiVersionConstant.ADMIN)
                .select()
                .apis(input -> {
                    SwaggerApiVersion apiVersion = input.getHandlerMethod().getMethodAnnotation(SwaggerApiVersion.class);
                    return apiVersion != null && Arrays.asList(apiVersion.group()).contains(AdamSwaggerApiVersionConstant.ADMIN);
                })
                .paths(PathSelectors.any())
                .build();
    }

    @Bean
    public Docket api_feign() {
        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(this.apiInfo())
                .groupName(AdamSwaggerApiVersionConstant.FEIGN)
                .select()
                .apis(input -> {
                    SwaggerApiVersion apiVersion = input.getHandlerMethod().getMethodAnnotation(SwaggerApiVersion.class);
                    return apiVersion != null && Arrays.asList(apiVersion.group()).contains(AdamSwaggerApiVersionConstant.FEIGN);
                })
                .paths(PathSelectors.any())
                .build();
    }

    @Bean
    public Docket api_task() {
        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(this.apiInfo())
                .groupName(AdamSwaggerApiVersionConstant.TASK)
                .select()
                .apis(input -> {
                    SwaggerApiVersion apiVersion = input.getHandlerMethod().getMethodAnnotation(SwaggerApiVersion.class);
                    return apiVersion != null && Arrays.asList(apiVersion.group()).contains(AdamSwaggerApiVersionConstant.TASK);
                })
                .paths(PathSelectors.any())
                .build();
    }

    @Bean
    public Docket web_sys() {
        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(this.apiInfo())
                .groupName(AdamSwaggerApiVersionConstant.WEB_SYS)
                .select()
                .apis(input -> {
                    SwaggerApiVersion apiVersion = input.getHandlerMethod().getMethodAnnotation(SwaggerApiVersion.class);
                    return apiVersion != null && Arrays.asList(apiVersion.group()).contains(AdamSwaggerApiVersionConstant.WEB_SYS);
                })
                .paths(PathSelectors.any())
                .build();
    }

    @Bean
    public Docket web_1_0() {
        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(this.apiInfo())
//                .globalOperationParameters(headParamDefault())
                .groupName(AdamSwaggerApiVersionConstant.WEB_1_0)
                .select()
                .apis(input -> {
                    SwaggerApiVersion apiVersion = input.getHandlerMethod().getMethodAnnotation(SwaggerApiVersion.class);
                    return apiVersion != null && Arrays.asList(apiVersion.group()).contains(AdamSwaggerApiVersionConstant.WEB_1_0);
                })
                .paths(PathSelectors.any())
                .build();
    }

    @Bean
    public Docket web_1_1() {
        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(this.apiInfo())
//                .globalOperationParameters(headParamDefault())
                .groupName(AdamSwaggerApiVersionConstant.WEB_1_1)
                .select()
                .apis(input -> {
                    SwaggerApiVersion apiVersion = input.getHandlerMethod().getMethodAnnotation(SwaggerApiVersion.class);
                    return apiVersion != null && Arrays.asList(apiVersion.group()).contains(AdamSwaggerApiVersionConstant.WEB_1_1);
                })
                .paths(PathSelectors.any())
                .build();
    }



    @Bean
    public Docket web_1_2() {
        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(this.apiInfo())
//                .globalOperationParameters(headParamDefault())
                .groupName(AdamSwaggerApiVersionConstant.WEB_1_2)
                .select()
                .apis(input -> {
                    SwaggerApiVersion apiVersion = input.getHandlerMethod().getMethodAnnotation(SwaggerApiVersion.class);
                    return apiVersion != null && Arrays.asList(apiVersion.group()).contains(AdamSwaggerApiVersionConstant.WEB_1_2);
                })
                .paths(PathSelectors.any())
                .build();
    }


    /**
     * 设置默认请求头部 参数
     * sid
     */
    private List<Parameter> headParamDefault() {
        List<Parameter> pars = new ArrayList<>();

//        ParameterBuilder ticketPar = new ParameterBuilder();
//        ticketPar.name("token").description("user token")
//                .modelRef(new ModelRef("string")).parameterType("header")
//                .required(true).build(); //header中的ticket参数非必填，传空也可以
//        pars.add(ticketPar.build());    //根据每个方法名也知道当前方法在设置什么参数
        return pars;
    }

}
