package com.liquidnet.service.kylin.dto.param;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.liquidnet.service.kylin.entity.KylinBanners;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author jxl <phpp.top> jiangxiulong
 * @description 添加banner参数
 * @create 2021-05-03 11:19 上午
 */

@Data
@ApiModel(value = "Bannersparam", description = "添加banner参数")
public class BannersParam implements Serializable {
    @ApiModelProperty(value = "Banner主键ID", required = false, example = "4345ASGMTG66")
    private String bannersId;

    @ApiModelProperty(value = "标题", required = true, example = "这是一个banner标题")
    private String name;

    @ApiModelProperty(value = "封面图", required = true, example = "img.zhengzai.tv/cover_img.ong")
    private String coverImg;

    @ApiModelProperty(value = "跳转目标id或者url", required = true, example = "1")
    private String targetId;

    @ApiModelProperty(value = "跳转类型 6演出跳转 7商品跳转 8巡演跳转 12展示分享按钮的web连接 14积分商品详情 100活动跳转 999不跳转 998个人信息跳转", required = true, example = "6")
    private Integer type;

    @ApiModelProperty(value = "是否显示 0-否,1-是", required = true, example = "1", allowableValues = "0,1")
    private Boolean isShow;

    @ApiModelProperty(value = "展示位置", required = true, example = "1")
    private Integer position;

    @ApiModelProperty(value = "排序权重 越大越靠前", required = true, example = "100")
    private Integer sort;

    @ApiModelProperty(value = "备注", required = false, example = "这是一个演出推广的banner")
    private String comment;

    @JsonIgnore
    public KylinBanners getFields(String fieldsId, LocalDateTime createdAt) {
        KylinBanners fields = new KylinBanners();
        BeanUtils.copyProperties(this, fields);
        if (null != fieldsId) {
            fields.setBannersId(fieldsId);
        }
        if (null != createdAt) {
            fields.setCreatedAt(createdAt);
        }
        return fields;
    }
}
