package com.liquidnet.service.kylin.controller.admin;


import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.kylin.dto.param.BannersParam;
import com.liquidnet.service.kylin.service.impl.admin.KylinBannersServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 轮播图 前端控制器
 * </p>
 *
 * @author jxl
 * @since 2021-05-01
 */

@Api
@RestController
@RequestMapping("/admin/banner")
public class KylinBannersController {

    @Autowired
    private KylinBannersServiceImpl kylinBannersServiceImpl;

    /**
     * 创建banner
     */
    @PostMapping("")
    @ApiOperation(value = "创建banner", httpMethod = "POST")
    public ResponseDto<Object> create(@RequestBody BannersParam param) {
        Boolean res = kylinBannersServiceImpl.create(param);
        if (res) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure("添加banner失败");
        }
    }

    /**
     * 修改banner
     */
    @PutMapping("")
    @ApiOperation(value = "修改banner", httpMethod = "PUT")
    public ResponseDto<Object> update(@RequestBody BannersParam param) {
        Boolean res = kylinBannersServiceImpl.update(param);
        if (res) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure("修改banner失败");
        }
    }

    /**
     * 详情
     */
    /*@GetMapping("")
    @ApiOperation(value = "详情", httpMethod = "GET")
    public ResponseDto<Object> detail(@RequestParam('banners_id') String bannersId) {
        Boolean res = kylinBannersServiceImpl.detail(param);
        if (res) {
            return ResponseDto.success();
        } else {
            return ResponseDto.failure("修改banner失败");
        }
    }*/

}
